% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_active_fire_counts.R
\name{active_fire_counts}
\alias{active_fire_counts}
\alias{calc_active_fire_counts}
\title{Calculate active fire counts based on NASA FIRMS polygons}
\usage{
calc_active_fire_counts()
}
\value{
A function that returns a tibble with a column for number of
fire events per year and instrument.
}
\description{
This function allows to efficiently calculate the number of fire
events occurred in the region of interest from the NASA FIRMS active
fire polygon datasets. For each polygon, the fire event counts for
the desired year is returned.
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{nasa_firms}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_nasa_firms(years = 2021, instrument = "VIIRS")) \%>\%
  calc_indicators(calc_active_fire_counts()) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
