% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_resource.R
\name{.get_single_resource}
\alias{.get_single_resource}
\title{Internal function used to process a single resource}
\usage{
.get_single_resource(x, resource, ...)
}
\arguments{
\item{x}{A portfolio object}

\item{resource}{A character vector of length one indicating a supported
resource}

\item{...}{Any additional arguments. The relevant arguments for the indicator
function are matched. If there are missing arguments, the default value is
used.}
}
\description{
This function is called internally by \code{get_resources()} to process
a single resource. It does argument matching filling any argument not
specified by the user with its default value from the backlog functions. It
informs users about the resource, the argument and the default value. It does
not check for the correctness of user specified arguments (this is handled
within the respective resource function). In the case the resource function
issues a warning or error it fails gracefully informing the user but
continuing processing other requested resources.
}
\keyword{internal}
