% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapbayest_check_and_preprocess.R
\name{check_mapbayr_model}
\alias{check_mapbayr_model}
\title{Check if model is valid for 'mapbayr'}
\usage{
check_mapbayr_model(x, check_compile = TRUE)
}
\arguments{
\item{x}{model file}

\item{check_compile}{check if model is compiled}
}
\value{
\code{TRUE} (invisibly) if checks are passed, errors otherwise.
}
\description{
Checks that the model respects points related exclusively to 'mapbayr'. Useful at the time you wish to convert a "regular" 'mrgsolve' model you used for simulation into a model to perform MAP-Bayesian estimation.
Note that some elements cannot be checked:
\itemize{
\item In \verb{$MAIN} block, make sure that you added \verb{ETA1, ETA2...} in the code. For instance: \verb{double CL = TVCL * exp(ETA(1) + ETA1) ;}.
\item In \verb{$OMEGA} block, make sure the order of the (diagonal) values is the same as for ETAs in \verb{$PARAM}. For instance, if \code{ETA1} corresponds to clearance, the first value in \verb{$OMEGA} must be the variance of clearance.
\item In \verb{$SIGMA} block, make sure the order is respected: proportional error first, and additive error secondly.
}
}
\examples{
library(mapbayr)
library(mrgsolve)
\dontrun{check_mapbayr_model(house())}
}
