% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_format.R
\name{manip_deformat}
\alias{manip_deformat}
\alias{to_unnamed}
\alias{to_undirected}
\alias{to_unweighted}
\alias{to_unsigned}
\alias{to_simplex}
\alias{to_uniplex}
\title{Modifying network formats by removing information}
\usage{
to_unnamed(.data)

to_undirected(.data)

to_unweighted(.data, threshold = 1)

to_unsigned(.data, keep = c("positive", "negative"))

to_simplex(.data)

to_uniplex(.data, tie)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{threshold}{For a matrix, the threshold to binarise/dichotomise at.}

\item{keep}{In the case of a signed network, whether to retain
the "positive" or "negative" ties.}

\item{tie}{Character string naming a tie attribute to retain from a graph.}
}
\value{
All \code{to_} functions return an object of the same class as that provided.
So passing it an igraph object will return an igraph object
and passing it a network object will return a network object,
with certain modifications as outlined for each function.
}
\description{
These functions reformat manynet-consistent data.
\itemize{
\item \code{to_unnamed()} reformats labelled network data to unlabelled network data.
\item \code{to_undirected()} reformats directed network data to an undirected network,
so that any pair of nodes with at least one directed edge will be
connected by an undirected edge in the new network.
This is equivalent to the "collapse" mode in \code{{igraph}}..
\item \code{to_unweighted()} reformats weighted network data to unweighted network
data, with all tie weights removed.
\item \code{to_unsigned()} reformats signed network data to unsigned network data
keeping just the "positive" or "negative" ties.
\item \code{to_simplex()} reformats complex network data, containing loops, to simplex network data, without any loops.
\item \code{to_uniplex()} reformats multiplex network data to a single type of tie.
}

If the format condition is not met,
for example \code{to_undirected()} is used on a network that is already undirected,
the network data is returned unaltered.
No warning is given so that these functions can be used to ensure conformance.

Unlike the \verb{as_*()} group of functions,
these functions always return the same class as they are given,
only transforming these objects' properties.
}
\details{
Not all functions have methods available for all object classes.
Below are the currently implemented S3 methods:\tabular{lrrrrr}{
    \tab data.frame \tab igraph \tab matrix \tab network \tab tbl_graph \cr
   to_simplex \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_undirected \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_uniplex \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_unnamed \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_unsigned \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_unweighted \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
}
}
\examples{
as_tidygraph(create_filled(5)) \%>\%
  mutate_ties(type = sample(c("friend", "enemy"), 10, replace = TRUE)) \%>\%
  to_uniplex("friend")
}
\seealso{
Other modifications: 
\code{\link{manip_as}},
\code{\link{manip_correlation}},
\code{\link{manip_from}},
\code{\link{manip_levels}},
\code{\link{manip_miss}},
\code{\link{manip_nodes}},
\code{\link{manip_paths}},
\code{\link{manip_permutation}},
\code{\link{manip_preformat}},
\code{\link{manip_project}},
\code{\link{manip_reformat}},
\code{\link{manip_scope}},
\code{\link{manip_split}},
\code{\link{manip_ties}}
}
\concept{modifications}
