% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm-translate.R
\name{llm_translate}
\alias{llm_translate}
\alias{llm_vec_translate}
\title{Translates text to a specific language}
\usage{
llm_translate(
  .data,
  col,
  language,
  pred_name = ".translation",
  additional_prompt = ""
)

llm_vec_translate(x, language, additional_prompt = "", preview = FALSE)
}
\arguments{
\item{.data}{A \code{data.frame} or \code{tbl} object that contains the text to be
analyzed}

\item{col}{The name of the field to analyze, supports \code{tidy-eval}}

\item{language}{Target language to translate the text to}

\item{pred_name}{A character vector with the name of the new column where the
prediction will be placed}

\item{additional_prompt}{Inserts this text into the prompt sent to the LLM}

\item{x}{A vector that contains the text to be analyzed}

\item{preview}{It returns the R call that would have been used to run the
prediction. It only returns the first record in \code{x}. Defaults to \code{FALSE}
Applies to vector function only.}
}
\value{
\code{llm_translate} returns a \code{data.frame} or \code{tbl} object.
\code{llm_vec_translate} returns a vector that is the same length as \code{x}.
}
\description{
Use a Large Language Model (LLM) to translate a text to a specific
language
}
\examples{
\donttest{
library(mall)

data("reviews")

llm_use("ollama", "llama3.2", seed = 100, .silent = TRUE)

# Pass the desired language to translate to
llm_translate(reviews, review, "spanish")
}
}
