% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dataset_functions.R
\name{data_extract}
\alias{data_extract}
\title{Create an empty dataset from a data dictionary}
\usage{
data_extract(data_dict, data_dict_apply = FALSE)
}
\arguments{
\item{data_dict}{A list of tibble(s) representing meta data of an
associated dataset (to be generated).}

\item{data_dict_apply}{whether to apply the data dictionary to its dataset.
The resulting tibble will have for each column its associated meta data as
attributes. The factors will be preserved. FALSE by default.}
}
\value{
A tibble identifying the dataset created from the variable names list in
'Variables' element of the data dictionary.
}
\description{
Creates an empty dataset using information contained in a data dictionary.
The column names are taken from 'name' in the 'Variables' element of the
data dictionary. If a 'valueType' or alternatively 'typeof' column is
provided, the class of each column is set accordingly (default is text).
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.
}
\examples{
{

# use DEMO_files provided by the package

data_dict <- DEMO_files$dd_MELBOURNE_1_format_maelstrom
data_extract(data_dict)

}

}
