% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ops.r
\docType{methods}
\name{marithops}
\alias{\%*\%,array,madness-class}
\alias{\%*\%,array,madness-method}
\alias{\%*\%,madness,array-class}
\alias{\%*\%,madness,array-method}
\alias{\%*\%,madness,madness-method}
\alias{`\%*\%`,madness,madness-class}
\alias{crossprod}
\alias{crossprod,ANY,madness-method}
\alias{crossprod,madness,ANY-method}
\alias{crossprod,madness,madness-method}
\alias{crossprod,madness,missing-method}
\alias{marithops}
\alias{tcrossprod}
\alias{tcrossprod,ANY,madness-method}
\alias{tcrossprod,madness,ANY-method}
\alias{tcrossprod,madness,madness-method}
\alias{tcrossprod,madness,missing-method}
\title{Basic Matrix Arithmetic Operations.}
\usage{
\S4method{\%*\%}{madness,madness}(x, y)

\S4method{\%*\%}{madness,array}(x, y)

\S4method{\%*\%}{array,madness}(x, y)

crossprod(x, y = NULL, ...)

\S4method{crossprod}{madness,madness}(x, y)

\S4method{crossprod}{madness,ANY}(x, y)

\S4method{crossprod}{madness,missing}(x, y)

\S4method{crossprod}{ANY,madness}(x, y)

tcrossprod(x, y = NULL, ...)

\S4method{tcrossprod}{madness,madness}(x, y)

\S4method{tcrossprod}{madness,ANY}(x, y)

\S4method{tcrossprod}{madness,missing}(x, y)

\S4method{tcrossprod}{ANY,madness}(x, y)
}
\arguments{
\item{x, y}{\code{madness} or numeric matrix values.}

\item{...}{ignored here.}
}
\description{
These perform basic matrix arithmetic on \code{madness} objects: matrix
multiplication, cross product, Kronecker product.
}
\examples{
set.seed(123)
y <- array(rnorm(3*3),dim=c(3,3))
dy <- matrix(rnorm(length(y)*2),ncol=2)
dx <- crossprod(matrix(rnorm(ncol(dy)*100),nrow=100))
obj0 <- madness(val=y,vtag='y',xtag='x',dvdx=dy,varx=dx)
z <- array(rnorm(3*3),dim=c(3,3))

anobj <- obj0 \%*\% obj0
anobj <- z \%*\% obj0
anobj <- crossprod(obj0)
anobj <- crossprod(obj0,z)
anobj <- tcrossprod(obj0,obj0)
# NYI: 
# anobj <- obj0 \%x\% obj0

}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}

