% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable.r
\name{mable.group}
\alias{mable.group}
\title{Mable fit of one-sample grouped data by an optimal or a preselected model degree}
\usage{
mable.group(x, breaks, M, interval = c(0, 1), IC = c("none", "aic",
  "hqic", "all"), controls = mable.ctrl(), progress = TRUE)
}
\arguments{
\item{x}{vector of frequencies}

\item{breaks}{class interval end points}

\item{M}{a positive integer or a vector \code{(m0, m1)}. If \code{M = m} or \code{m0 = m1 = m},
then \code{m} is a preselected degree. If \code{m0<m1} it specifies the set of
consective candidate model degrees \code{m0:m1} for searching an optimal degree,
where \code{m1-m0>3}.}

\item{interval}{a vector containing the endpoints of support/truncation interval}

\item{IC}{information criterion(s) in addition to Bayesian information criterion (BIC). Current choices are
"aic" (Akaike information criterion) and/or
"qhic" (Hannan–Quinn information criterion).}

\item{controls}{Object of class \code{mable.ctrl()} specifying iteration limit
and the convergence criterion \code{eps}. Default is \code{\link{mable.ctrl}}. See Details.}

\item{progress}{if TRUE a text progressbar is displayed}
}
\value{
A list with components
\itemize{
  \item \code{m} the given/selected optimal degree by the method of change-point
  \item \code{p} the estimated \code{p} with degree \code{m}
  \item \code{mloglik}  the maximum log-likelihood at degree \code{m}
  \item \code{interval} supporting interval \code{(a, b)}
  \item \code{convergence} An integer code. 0 indicates successful completion
   (all the EM iterations are convergent and an optimal degree
    is successfully selected in \code{M}). Possible error codes are
   \itemize{
      \item 1, indicates that the iteration limit \code{maxit} had been
          reached in at least one EM iteration;
      \item 2, the search did not finish before \code{m1}.
    }
  \item \code{delta} the convergence criterion \code{delta} value
 }
 and, if \code{m0<m1},
\itemize{
  \item \code{M} the vector \code{(m0, m1)}, where \code{m1}, if greater than \code{m0}, is the
     largest candidate when the search stoped
  \item \code{lk} log-likelihoods evaluated at \eqn{m \in \{m_0, \ldots, m_1\}}
  \item \code{lr} likelihood ratios for change-points evaluated at \eqn{m \in \{m_0+1, \ldots, m_1\}}
  \item \code{ic} a list containing the selected information criterion(s)
  \item \code{pval} the p-values of the change-point tests for choosing optimal model degree
  \item \code{chpts} the change-points chosen with the given candidate model degrees
}
}
\description{
Maximum approximate Bernstein/Beta likelihood estimation based on
 one-sample grouped data with an optimal selected by the change-point method among \code{m0:m1}
 or a preselected model degree \code{m}.
}
\details{
Any continuous density function \eqn{f} on a known closed supporting interval \eqn{[a, b]} can be
 estimated by Bernstein polynomial \eqn{f_m(x; p) = \sum_{i=0}^m p_i\beta_{mi}[(x-a)/(b-a)]/(b-a)},
 where \eqn{p = (p_0, \ldots, p_m)}, \eqn{p_i\ge 0}, \eqn{\sum_{i=0}^m p_i=1} and
 \eqn{\beta_{mi}(u) = (m+1){m\choose i}u^i(1-x)^{m-i}}, \eqn{i = 0, 1, \ldots, m},
 is the beta density with shapes \eqn{(i+1, m-i+1)}.
 For each \code{m}, the MABLE of the coefficients \code{p}, the mixture proportions, are
 obtained using EM algorithm. The EM iteration for each candidate \code{m} stops if either
 the total absolute change of the log likelihood and the coefficients of Bernstein polynomial
 is smaller than \code{eps} or the maximum number of iterations \code{maxit} is reached.

 If \code{m0<m1}, an optimal model degree is selected as the change-point of the increments of
 log-likelihood, log likelihood ratios, for \eqn{m \in \{m_0, m_0+1, \ldots, m_1\}}. Alternatively,
 one can choose an optimal degree based on the BIC (Schwarz, 1978) which are evaluated at
 \eqn{m \in \{m_0, m_0+1, \ldots, m_1\}}. The search for optimal degree \code{m} is stoped if either
 \code{m1} is reached with a warning or the test for change-point results in a p-value \code{pval}
 smaller than \code{sig.level}.  The BIC for a given degree \code{m} is calculated as in
 Schwarz (1978) where the dimension of the model is \eqn{d=\#\{i: \hat p_i \ge \epsilon,
 i = 0, \ldots, m\} - 1} and a default \eqn{\epsilon} is chosen as \code{.Machine$double.eps}.
}
\examples{
\donttest{
## Chicken Embryo Data
 data(chicken.embryo)
 a<-0; b<-21
 day<-chicken.embryo$day
 nT<-chicken.embryo$nT
 Day<-rep(day,nT)
 res<-mable.group(x=nT, breaks=a:b, M=c(2,100), interval=c(a, b), IC="aic",
    controls=mable.ctrl(sig.level=1e-6,  maxit=2000, eps=1.0e-7))
 op<-par(mfrow=c(1,2), lwd=2)
 layout(rbind(c(1, 2), c(3, 3)))
 plot(res, which="likelihood")
 plot(res, which="change-point")
 fk<-density(x=rep((0:20)+.5, nT), bw="sj", n=101, from=a, to=b)
 hist(Day, breaks=seq(a,b,  length=12), freq=FALSE, col="grey",
          border="white", main="Histogram and Density Estimates")
 plot(res, which="density",types=1:2, colors=1:2)
 lines(fk, lty=2, col=2)
 legend("topright", lty=c(1:2), c("MABLE", "Kernel"), bty="n", col=c(1:2))
 par(op)
}
}
\references{
Guan, Z. (2017) Bernstein polynomial model for grouped continuous data.
        \emph{Journal of Nonparametric Statistics}, 29(4):831-848.
}
\seealso{
\code{\link{mable.ic}}
}
\author{
Zhong Guan <zguan@iusb.edu>
}
\concept{Bernstein polynomial model}
\keyword{distribution}
\keyword{models}
\keyword{nonparametric}
\keyword{smooth}
\keyword{univar}
