% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vif.R
\name{vif}
\alias{vif}
\alias{vif.default}
\alias{vif.lm}
\alias{vif.lmerMod}
\title{Variance inflation factor}
\usage{
vif(model)

\method{vif}{default}(model)

\method{vif}{lm}(model)

\method{vif}{lmerMod}(model)
}
\arguments{
\item{model}{An object containing a model.}
}
\value{
It returns a \code{data.frame} with three columns: the name of the
model term, the VIF value and its classification (see "Details").
}
\description{
Computes the variance inflation factor (VIF). The VIF is a measure of how
much the variance of a regression coefficient is increased due to
collinearity.
}
\details{
\subsection{VIF interpretation}{

As a rule of thumb for the interpretation of the VIF value, a VIF
less than 5 indicates a low correlation of a given model term with the
others, a VIF between 5 and 10 indicates a moderate correlation and a
VIF greater than 10 indicates a high correlation.
}
}
\examples{
m <- lm(disp ~ mpg + cyl + mpg:cyl, mtcars)
vif(m)
}
\references{
\itemize{
\item James, G., Witten, D., Hastie, T., & Tibshirani, R. (eds.). (2013).
An introduction to statistical learning: with applications in R. New York:
Springer.
}
}
