% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltspca.R
\name{ltspca}
\alias{ltspca}
\title{Principal Component Analysis Based on Least Trimmed Squaers (LTS-PCA)}
\usage{
ltspca(x, q, alpha = 0.5, b.choice = NULL, tol = 1e-06, N1 = 3,
  N2 = 2, N2bis = 10, Npc = 10)
}
\arguments{
\item{x}{the input data matrix}

\item{q}{the dimension of the PC subspace}

\item{alpha}{the robust parameter which takes value between 0 to 0.5, default is 0.5}

\item{b.choice}{intial loading matrix; by default is NULL and the deterministic starting values will be computed by the algorithm}

\item{tol}{convergence criterion}

\item{N1}{the number controls the updates for a without updating b in the concentration step}

\item{N2}{the number controls outer loop in the concentration step}

\item{N2bis}{the number controls the outer loop for the selected b}

\item{Npc}{the number controls the inner loop}
}
\value{
the object of class "ltspca" is returned \cr
\item{b}{the unnormalized loading matrix}
\item{mu}{the center estimate}
\item{ws}{if the observation in included in the h-subset \code{ws}=1; otherwise \code{ws}=0}
\item{best.cand}{the method which computes the best deterministic starting value in the concentration step}
}
\description{
the function that computes LTS-PCA
}
\examples{
\dontrun{
ltspcaM <- ltspca(x = x, q = 2, alpha = 0.5)
}
}
\references{
Cevallos Valdiviezo, H., Van Aelst, S. (2019), `` Fast computation of robust subspace estimators'', \emph{Computational Statistics & Data Analysis}, 134, 171--185.
}
\author{
Cevallos Valdiviezo
}
