% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignSurvivals.R
\name{pwexploglik}
\alias{pwexploglik}
\title{Profile Log-Likelihood Function for the Change Points in
Piecewise Exponential Approximation}
\usage{
pwexploglik(tau, S, ...)
}
\arguments{
\item{tau}{The numeric vector of change points.}

\item{S}{The survival function of a univariate survival time.}

\item{...}{Additional arguments to be passed to S.}
}
\value{
A list with the following three components:
\itemize{
\item \code{piecewiseSurvivalTime}: A vector that specifies the starting
time of piecewise exponential survival time intervals.
\item \code{lambda}: A vector of hazard rates for the event. One for
each analysis time interval.
\item \code{loglik}: The value of the profile log-likelihood.
}
}
\description{
Obtains the profile log-likelihood function for the
change points in the piecewise exponential approximation to
a survival function.
}
\examples{

pwexploglik(tau = c(0.5, 1.2, 2.8), pweibull,
            shape = 1.37, scale = 1/0.818, lower.tail = FALSE)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
