% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_meta.R
\name{read_meta}
\alias{read_meta}
\title{Read an LPJmL meta file or binary file header}
\usage{
read_meta(filename, ...)
}
\arguments{
\item{filename}{Character string representing path
(if different from current working directory) and filename.}

\item{...}{Additional arguments passed to \code{\link{read_header}} if header file is
read.}
}
\value{
An \code{\link{LPJmLMetaData}} object.
}
\description{
Reads a meta JSON file or the header of a binary LPJmL input or output file.
}
\examples{
\dontrun{
 meta <- read_meta(filename = "mpft_npp.bin.json")

 meta$sim_name
 # [1] "LPJmL Run"

 meta$firstcell
 # [1] 27410

 meta$band_names[1]
 # [1] "tropical broadleaved evergreen tree"
}

}
