
## add some data for convenience

namespace eval loon::data {

    ## Iris Data
    ## Fisher, R. A. (1936) The use of multiple measurements in taxonomic 
    ## problems.  Annals of Eugenics, 7, Part II, 179-188.
    ##
    ## as seen in iris data in datasets R package
    set iris [dict create\
		  SepalLength {5.1 4.9 4.7 4.6 5 5.4 4.6 5 4.4 4.9 5.4 4.8 4.8 4.3 5.8 5.7 5.4 5.1 5.7 5.1 5.4 5.1 4.6 5.1 4.8 5 5 5.2 5.2 4.7 4.8 5.4 5.2 5.5 4.9 5 5.5 4.9 4.4 5.1 5 4.5 4.4 5 5.1 4.8 5.1 4.6 5.3 5 7 6.4 6.9 5.5 6.5 5.7 6.3 4.9 6.6 5.2 5 5.9 6 6.1 5.6 6.7 5.6 5.8 6.2 5.6 5.9 6.1 6.3 6.1 6.4 6.6 6.8 6.7 6 5.7 5.5 5.5 5.8 6 5.4 6 6.7 6.3 5.6 5.5 5.5 6.1 5.8 5 5.6 5.7 5.7 6.2 5.1 5.7 6.3 5.8 7.1 6.3 6.5 7.6 4.9 7.3 6.7 7.2 6.5 6.4 6.8 5.7 5.8 6.4 6.5 7.7 7.7 6 6.9 5.6 7.7 6.3 6.7 7.2 6.2 6.1 6.4 7.2 7.4 7.9 6.4 6.3 6.1 7.7 6.3 6.4 6 6.9 6.7 6.9 5.8 6.8 6.7 6.7 6.3 6.5 6.2 5.9}\
		  SepalWidth {3.5 3 3.2 3.1 3.6 3.9 3.4 3.4 2.9 3.1 3.7 3.4 3 3 4 4.4 3.9 3.5 3.8 3.8 3.4 3.7 3.6 3.3 3.4 3 3.4 3.5 3.4 3.2 3.1 3.4 4.1 4.2 3.1 3.2 3.5 3.6 3 3.4 3.5 2.3 3.2 3.5 3.8 3 3.8 3.2 3.7 3.3 3.2 3.2 3.1 2.3 2.8 2.8 3.3 2.4 2.9 2.7 2 3 2.2 2.9 2.9 3.1 3 2.7 2.2 2.5 3.2 2.8 2.5 2.8 2.9 3 2.8 3 2.9 2.6 2.4 2.4 2.7 2.7 3 3.4 3.1 2.3 3 2.5 2.6 3 2.6 2.3 2.7 3 2.9 2.9 2.5 2.8 3.3 2.7 3 2.9 3 3 2.5 2.9 2.5 3.6 3.2 2.7 3 2.5 2.8 3.2 3 3.8 2.6 2.2 3.2 2.8 2.8 2.7 3.3 3.2 2.8 3 2.8 3 2.8 3.8 2.8 2.8 2.6 3 3.4 3.1 3 3.1 3.1 3.1 2.7 3.2 3.3 3 2.5 3 3.4 3}\
		  PetalLength {1.4 1.4 1.3 1.5 1.4 1.7 1.4 1.5 1.4 1.5 1.5 1.6 1.4 1.1 1.2 1.5 1.3 1.4 1.7 1.5 1.7 1.5 1 1.7 1.9 1.6 1.6 1.5 1.4 1.6 1.6 1.5 1.5 1.4 1.5 1.2 1.3 1.4 1.3 1.5 1.3 1.3 1.3 1.6 1.9 1.4 1.6 1.4 1.5 1.4 4.7 4.5 4.9 4 4.6 4.5 4.7 3.3 4.6 3.9 3.5 4.2 4 4.7 3.6 4.4 4.5 4.1 4.5 3.9 4.8 4 4.9 4.7 4.3 4.4 4.8 5 4.5 3.5 3.8 3.7 3.9 5.1 4.5 4.5 4.7 4.4 4.1 4 4.4 4.6 4 3.3 4.2 4.2 4.2 4.3 3 4.1 6 5.1 5.9 5.6 5.8 6.6 4.5 6.3 5.8 6.1 5.1 5.3 5.5 5 5.1 5.3 5.5 6.7 6.9 5 5.7 4.9 6.7 4.9 5.7 6 4.8 4.9 5.6 5.8 6.1 6.4 5.6 5.1 5.6 6.1 5.6 5.5 4.8 5.4 5.6 5.1 5.1 5.9 5.7 5.2 5 5.2 5.4 5.1}\
		  PetalWidth {0.2 0.2 0.2 0.2 0.2 0.4 0.3 0.2 0.2 0.1 0.2 0.2 0.1 0.1 0.2 0.4 0.4 0.3 0.3 0.3 0.2 0.4 0.2 0.5 0.2 0.2 0.4 0.2 0.2 0.2 0.2 0.4 0.1 0.2 0.2 0.2 0.2 0.1 0.2 0.2 0.3 0.3 0.2 0.6 0.4 0.3 0.2 0.2 0.2 0.2 1.4 1.5 1.5 1.3 1.5 1.3 1.6 1 1.3 1.4 1 1.5 1 1.4 1.3 1.4 1.5 1 1.5 1.1 1.8 1.3 1.5 1.2 1.3 1.4 1.4 1.7 1.5 1 1.1 1 1.2 1.6 1.5 1.6 1.5 1.3 1.3 1.3 1.2 1.4 1.2 1 1.3 1.2 1.3 1.3 1.1 1.3 2.5 1.9 2.1 1.8 2.2 2.1 1.7 1.8 1.8 2.5 2 1.9 2.1 2 2.4 2.3 1.8 2.2 2.3 1.5 2.3 2 2 1.8 2.1 1.8 1.8 1.8 2.1 1.6 1.9 2 2.2 1.5 1.4 2.3 2.4 1.8 1.8 2.1 2.4 2.3 1.9 2.3 2.5 2.3 1.9 2 2.3 1.8}\
		  Species {setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa setosa versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor versicolor virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica virginica}]

    ## olive data
    ##
    ##
    ## source:
    ## Forina, M., Armanino, C., Lanteri, S., and Tiscornia, E. (1983)
    ## ``Classification of Olive Oils from their Fatty Acid
    ## Composition'', in _Food Research and Data Analysis_ (Martens, H.,
    ## Russwurm, H., eds.), p. 189, Applied Science Publ., Barking.
    ##
    ## as seen in olive data in loon package

    set olive [dict create\
		   Region {South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South South Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia Sardinia North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North North}\
		   Area {North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia North-Apulia Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria Calabria South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily Sicily South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia South-Apulia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Inland-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Coast-Sardinia Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria Umbria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria East-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria West-Liguria}\
		   palmitic {1075 1088 911 966 1051 911 922 1100 1082 1037 1051 1036 1074 875 952 1155 943 1278 961 952 1074 995 1056 1065 1065 1315 1321 1359 1378 1295 1275 1336 1309 1340 1299 1221 1245 1285 1248 1356 1260 1261 1304 1344 1323 1292 1254 1312 1213 1359 1266 1298 1272 1278 1184 1382 1183 1261 1198 1225 1339 1132 1381 1409 1306 1372 1336 1401 1390 1432 1412 1366 1383 1283 1296 1287 1351 1241 1267 1235 1255 1454 1347 1364 1410 1384 1412 1410 1509 1317 1286 1273 1463 1399 1413 1369 1488 1323 1311 1286 1380 1394 1324 1290 1361 1387 1369 1303 1346 1369 1305 1351 1283 1449 1310 1360 1300 1368 1207 1348 1334 1301 1226 1201 1297 1248 1335 1219 1318 1264 1201 1252 1273 1351 1336 1499 1425 1358 1346 1392 1311 1314 1409 1342 1387 1413 1430 1336 1372 1330 1412 1321 1401 1401 1457 1451 1438 1462 1529 1510 1437 1327 1438 1447 1355 1369 1471 1456 1314 1408 1397 1413 1539 1304 1341 1508 1515 1262 1307 1294 1460 1476 1482 1388 1367 1272 1323 1206 1383 1521 1350 1422 1298 1447 1347 1339 1388 1527 1495 1487 1399 1489 1339 1482 1434 1347 1340 1453 1306 1349 1254 1168 1346 1390 1283 1214 1491 1479 1445 1439 1387 1426 1451 1493 1419 1342 1349 1440 1460 1249 1348 1341 1398 1454 1334 1438 1303 1323 1417 1360 1420 1472 1368 1367 1403 1413 1201 1359 1518 1434 1367 1461 1368 1419 1514 1328 1469 1222 1639 1345 1339 1194 1112 1222 1136 926 1105 1109 1284 1120 916 905 1206 1457 1327 1303 1444 1505 1429 1491 1393 1404 1222 1153 1169 1369 993 980 967 1128 1188 1257 1262 1283 1263 1369 1353 1187 1732 1620 1543 1498 1399 1293 1420 1721 1742 1391 1517 1269 1577 1590 1621 1753 1679 1419 1693 1692 1638 1497 1442 1680 1463 1129 1042 1103 1118 1052 1116 1108 1129 1085 1104 1098 1135 1158 1133 1095 1201 1213 1108 1075 1059 1176 1159 1132 1107 1092 1119 1106 1047 1165 1158 1095 1176 1103 1112 1091 1080 1051 1096 1142 1047 1114 1140 1075 1092 1076 1178 1095 1166 1154 1177 1160 1122 1132 1096 1131 1184 1135 1084 1086 1140 1138 1159 1051 1048 1061 1105 1145 1049 1105 1030 1070 1103 1040 1100 1118 1065 1131 1080 1075 1040 1128 1060 1103 1110 1091 1094 1131 1175 1076 1120 1152 1141 1098 1126 1087 1115 1178 1162 1085 1085 1090 1080 1090 1105 1060 1050 1100 1065 1085 1080 1085 1075 1090 1095 1090 1095 1090 1095 1095 1080 1090 1105 1110 1075 1075 1065 1070 1070 1100 1075 1050 1090 1050 1075 1098 1105 1110 1058 1115 1105 1072 1110 1110 1055 1100 1105 1095 1110 1092 1290 1170 1100 1120 1160 1200 1140 1220 1180 1210 1220 1180 1160 1130 1080 1090 1020 1090 1120 1080 1160 1100 1050 1090 1120 1120 1190 1170 1120 1190 1400 1350 1090 1150 1240 1220 1180 1170 1170 1180 1200 1140 1160 1130 1150 1110 1150 1180 1020 610 1190 1110 1020 1070 1010 1060 1060 1030 1120 1030 1070 1140 1090 980 980 960 990 1060 1240 1060 1020 970 1180 1060 990 1010 1040 1040 1020 1020 1010 920 1030 960 1030 1010 1020 1120 1090 1100 1090 1150 1110 1010 1070 1280 1060 1010 990 960}\
		   palmitoleic {75 73 54 57 67 49 66 61 60 55 35 59 70 52 49 98 94 69 70 77 67 46 53 39 45 139 136 115 111 109 121 120 122 114 116 107 72 129 107 106 102 121 124 117 96 117 118 131 109 98 97 99 116 87 112 110 146 153 136 134 166 157 183 128 127 120 113 151 119 152 124 147 118 102 136 108 159 97 101 138 103 183 194 204 199 178 185 232 209 197 192 191 183 187 193 206 172 160 166 163 173 164 174 157 163 182 180 165 160 171 172 179 151 175 180 163 187 171 151 154 186 156 181 168 153 163 159 167 179 167 175 180 182 179 155 201 198 204 181 186 166 171 200 174 182 202 209 185 200 157 207 209 200 214 168 199 206 204 215 189 222 129 172 176 144 156 188 179 140 176 172 191 194 159 160 208 226 165 197 159 187 187 178 176 172 207 157 218 157 190 168 181 166 236 197 170 183 260 237 246 180 215 166 246 172 156 158 180 149 161 151 144 167 184 149 137 227 218 174 183 154 169 200 204 192 177 152 196 215 133 159 155 149 200 153 204 138 147 169 167 179 218 174 173 173 197 138 180 198 185 162 181 161 159 162 171 160 133 172 133 170 135 68 70 72 41 69 79 93 69 52 49 55 182 140 100 175 243 162 162 128 134 130 74 76 104 58 53 55 73 85 95 88 153 155 158 172 139 231 255 172 170 169 156 175 238 221 187 206 157 204 241 280 275 260 203 236 270 252 247 222 270 164 120 135 96 97 95 102 132 108 91 103 88 98 108 110 125 87 112 92 103 96 92 98 80 75 104 81 93 101 99 84 88 75 109 92 93 98 108 84 97 96 86 93 91 106 95 89 104 97 119 111 96 104 99 100 87 105 94 96 127 95 101 110 78 79 86 88 35 96 120 84 98 81 101 95 85 98 78 120 86 103 82 111 78 91 108 96 87 108 77 90 111 95 103 100 89 96 92 106 70 70 60 65 60 55 75 70 55 65 60 65 60 68 58 60 58 58 58 58 55 70 60 55 50 70 65 75 75 75 70 70 78 60 78 70 54 15 75 50 30 30 49 15 80 60 80 55 50 50 37 60 80 90 70 70 50 50 80 90 70 80 100 90 100 100 90 100 90 100 80 70 80 100 90 80 100 90 110 100 80 90 80 60 90 90 100 80 110 100 80 90 90 70 80 80 70 70 80 80 80 150 130 100 120 90 140 140 100 130 110 100 180 180 110 90 90 90 120 150 90 100 90 130 140 100 90 90 90 90 90 90 110 100 90 110 100 90 90 90 120 80 90 90 110 100 110 100 90 120 80}\
		   stearic {226 224 246 240 259 268 264 235 239 213 219 235 214 243 254 201 183 205 195 258 236 288 247 234 245 230 217 246 272 245 215 318 241 189 253 221 283 244 313 236 228 312 279 287 300 215 244 259 301 351 263 311 279 332 311 268 292 219 239 232 208 240 245 257 250 250 242 238 234 281 298 291 273 263 260 287 296 268 300 252 223 196 197 225 216 208 217 280 257 256 203 202 183 191 208 203 170 205 170 183 188 223 198 192 196 242 181 175 169 184 169 186 182 198 183 176 196 218 156 183 229 207 213 190 177 158 197 171 177 166 201 181 209 170 212 182 193 227 257 256 222 229 207 221 206 205 225 223 200 228 208 217 217 217 242 221 248 237 203 245 184 247 252 189 214 241 276 240 207 192 191 186 213 234 231 249 257 235 238 253 215 203 197 185 235 205 234 242 217 238 227 218 224 245 211 253 216 232 236 251 232 242 226 238 255 214 233 244 226 217 205 220 224 212 224 232 205 207 228 218 204 192 208 188 207 199 236 208 197 205 238 244 204 199 219 189 212 210 207 225 214 214 205 228 209 206 207 207 225 189 179 197 198 215 298 253 337 227 331 272 275 263 375 329 341 277 373 305 265 277 281 288 287 267 193 251 259 226 223 211 211 210 214 316 307 237 267 254 273 354 273 247 301 196 199 215 175 185 156 166 193 195 171 191 152 255 156 189 249 193 208 195 197 236 177 176 174 234 215 219 194 170 185 222 210 210 221 215 231 231 212 223 233 212 251 245 241 250 238 245 231 207 228 207 213 201 220 234 219 212 238 214 201 203 205 220 209 222 219 227 211 225 236 210 241 200 219 204 201 223 272 257 241 240 241 257 260 233 258 235 240 252 258 254 261 211 213 220 210 237 219 218 214 215 208 205 210 199 230 221 218 231 228 203 231 220 201 218 220 208 214 202 240 238 250 267 236 243 236 241 242 180 185 190 189 195 200 175 170 198 178 188 180 190 195 192 198 195 198 195 198 200 188 195 200 205 198 185 180 188 188 200 185 175 198 188 190 202 198 220 178 225 198 178 210 215 175 215 205 210 220 210 260 230 250 240 250 210 200 240 250 250 220 190 220 240 260 280 270 250 260 240 230 240 250 270 260 250 230 250 230 270 270 250 220 230 220 240 250 240 280 220 240 240 210 250 240 240 220 240 250 230 290 210 220 210 350 240 270 230 250 220 230 220 230 300 330 200 210 210 250 310 290 220 220 240 250 350 250 250 350 260 350 340 250 300 210 240 240 300 290 280 240 250 230 210 220 290 270 210 250 240}\
		   oleic {7823 7709 8113 7952 7771 7924 7990 7728 7745 7944 7978 7868 7728 8018 7795 7606 7840 7344 7958 7820 7692 7806 7703 7876 7779 7299 7174 7234 7127 7253 7285 7083 7257 7337 7309 7441 7395 7323 7299 7209 7354 7238 7160 7129 7351 7351 7394 7167 7261 7262 7435 7311 7258 7379 7391 7241 7580 7355 7639 7658 7190 7641 7385 7257 7254 7355 7293 7164 7236 7029 7182 7197 7282 7400 7380 7343 7229 7499 7230 7322 7395 7057 7277 6929 7130 7105 6842 6715 6647 7036 7132 6862 6747 6861 6875 6953 6920 6911 6902 7040 7038 7086 6863 7000 6888 6913 7000 7025 7072 6937 7004 6935 7000 6883 7054 6901 6920 7010 7159 6917 7261 7003 6961 7100 7004 7103 6974 7087 7030 7130 7129 7055 6965 7034 7103 6803 7032 6962 7147 6732 7006 6923 6842 6993 7100 6920 6800 6956 6916 7055 6822 6948 6980 6734 6724 6835 6806 6644 6602 6752 6803 7024 6630 6849 6972 6890 6697 6738 7020 6909 7107 6937 6764 7019 7033 6641 6595 7120 7003 7009 6843 6837 6814 7008 7066 7152 7132 7193 7018 6956 6986 6813 6986 6607 6795 6989 6867 6488 6571 6504 6855 6777 6928 6444 6646 6850 6848 6752 7082 6997 7319 7230 6959 6898 7077 7269 6941 7039 6875 6775 6991 7025 6980 6913 6996 7172 7145 6938 6918 7417 7017 6958 7182 6910 6928 7107 7170 7108 6875 6883 6923 6724 7042 6948 6843 6737 7011 6895 6681 6771 6772 6783 7030 6862 6725 6987 6675 7425 6510 6801 6838 7277 7770 7605 7616 7815 7714 7576 7235 7416 7870 7747 7329 7020 7328 7045 6876 6962 6917 6994 7189 7110 7374 7593 7553 7375 7743 7719 7692 7527 7445 7405 7471 7107 7140 7160 6965 7427 6437 6628 6740 6804 7011 7101 7004 6300 6415 6975 6680 7140 6732 6705 6608 6367 6568 6973 6499 6499 6570 6621 6677 6440 6909 7272 7376 7380 7279 7388 7290 7319 7386 7384 7322 7338 7120 7065 7080 7120 6990 7007 7367 7413 7386 7347 7320 7398 7399 7355 7409 7381 7385 7331 7327 7415 7396 7335 7356 7377 7371 7403 7415 7341 7399 7359 7324 7410 7427 7408 7381 7367 6971 7130 6882 7043 7145 7065 7162 7144 7020 7123 7164 7159 7085 7103 7068 7421 7439 7421 7353 7208 7303 7302 7403 7280 7310 7368 7320 7415 7345 7358 7296 7403 7364 7320 7363 7365 7318 7383 7341 7170 7076 7243 7068 7080 7035 7135 7062 7200 7085 7006 7025 7955 7955 7950 7960 7955 7900 7975 7977 7905 7965 7955 7960 7955 7960 7950 7945 7950 7950 7940 7945 7940 7965 7950 7900 7900 7978 7980 7975 7980 7980 7910 7960 7990 7945 7990 7975 7945 8005 7915 7988 7955 7995 7980 7990 7910 7985 7930 7965 7948 7950 7955 7550 7690 7680 7720 7650 7770 7990 7610 7520 7560 7540 7520 7580 7620 7710 7730 7770 7680 7720 7830 7860 7820 7930 7780 7750 7680 7670 7620 7720 7690 7420 7520 7890 7790 7820 7890 7870 7730 7710 7790 7820 7880 7870 7780 7800 7820 7850 7760 7920 8410 7340 7550 7530 7600 7480 7680 7620 7740 7530 7760 7600 7610 7590 7720 7540 7810 7780 7600 7610 7850 7620 7700 7450 7690 7630 7630 7780 7810 7620 7620 7610 7720 7710 7820 7810 7710 7800 7650 7710 7630 7820 7720 7810 7720 7730 7490 7740 7720 7750 7950}\
		   linoleic {672 781 549 619 672 678 618 734 709 633 605 661 747 655 780 816 788 957 742 736 716 679 700 703 696 832 950 874 940 903 892 915 870 820 823 798 829 819 840 866 870 877 928 897 757 839 786 939 925 780 743 787 872 771 819 828 618 818 633 616 923 638 609 759 869 702 855 857 823 949 790 783 738 763 780 826 810 709 898 861 848 1014 895 1084 955 999 1203 1233 1240 1067 1053 1303 1307 1233 1202 1168 1144 1298 1312 1230 1139 1042 1289 1263 1273 1101 1130 1243 1151 1246 1260 1243 1271 1162 1202 1280 1253 1057 1234 1277 827 1229 1230 1216 1260 1222 1220 1254 1194 1187 1193 1214 1191 1154 1086 1204 1041 1109 933 1278 1147 1198 1224 1147 1020 1165 1200 1155 1189 1108 1239 1178 1073 1293 1266 1177 1183 1309 1310 1188 1240 1157 1380 1180 1198 1209 1269 1267 1220 1195 1018 1180 1178 1174 1069 1311 1287 1113 1144 1190 1172 1197 1201 1111 1054 1098 1022 1002 1090 986 1165 1230 1162 1336 1300 1110 1208 1370 1318 1390 1190 1145 1198 1462 1354 1313 1272 1238 1097 1138 947 1109 1111 1189 1104 1005 988 887 1123 1226 1090 1043 1006 1044 1014 952 949 1070 1081 827 1081 1144 907 1090 1214 910 1016 1070 1184 1220 1121 1238 1066 1141 1210 1387 1269 1203 1243 1269 1368 1246 1095 1193 1119 1030 1127 824 1124 1194 1060 889 448 566 661 784 532 763 893 946 694 812 935 863 823 1049 1027 858 1041 928 870 923 856 705 728 775 773 815 833 728 814 812 704 1115 1148 958 1212 952 1313 1212 1157 1206 1100 1111 1149 1350 1315 1062 1205 1148 1183 1149 1179 1214 1191 1083 1204 1196 1199 1270 1314 1310 1154 1112 1116 1085 1154 1126 1168 1101 1074 1126 1147 1140 1314 1326 1342 1305 1383 1335 1110 1096 1128 1057 1108 1095 1096 1126 1057 1104 1120 1101 1123 1093 1107 1140 1125 1113 1125 1114 1091 1101 1107 1116 1098 1107 1125 1130 1099 1111 1390 1253 1470 1357 1313 1362 1282 1307 1340 1320 1330 1285 1347 1310 1297 1146 1130 1102 1142 1118 1168 1158 1177 1240 1177 1176 1113 1060 1163 1120 1145 1109 1173 1148 1149 1149 1185 1183 1127 1308 1307 1305 1383 1372 1388 1301 1380 1302 1372 1376 1368 605 600 600 602 600 600 610 605 600 605 602 605 602 602 600 600 600 602 600 600 600 608 600 595 595 608 608 610 602 602 610 610 610 600 608 605 595 575 510 626 600 570 615 570 525 620 535 600 600 600 600 670 720 760 730 750 690 580 760 800 780 770 820 790 780 750 720 710 760 680 670 640 670 630 690 680 730 710 740 730 720 800 760 670 650 590 530 580 630 640 680 590 570 580 650 630 670 620 670 680 650 1020 1000 1030 990 1050 830 880 900 970 980 990 850 860 910 1040 940 930 1010 730 690 960 1020 1010 850 1030 940 820 810 920 1010 930 910 900 830 840 910 850 830 800 770 760 810 750 950 870 790 810 970 870 740}\
		   linolenic {36 31 31 50 50 51 49 39 46 26 21 30 50 41 50 32 42 45 46 43 56 56 54 42 47 42 43 45 46 43 40 50 46 48 40 54 44 57 46 48 49 47 48 51 47 48 46 41 47 41 45 45 43 44 48 39 38 52 27 36 40 45 47 43 47 44 38 45 40 39 45 51 45 54 48 44 36 52 74 54 47 27 25 21 21 29 34 32 42 40 38 43 36 38 30 35 37 24 41 29 31 24 36 26 37 44 39 31 39 30 28 36 40 40 26 28 41 41 27 48 34 41 47 43 35 31 36 35 35 22 36 31 43 35 33 30 31 41 40 53 41 47 31 36 34 36 32 56 33 42 36 42 40 44 54 37 34 42 45 36 43 38 40 42 33 42 34 41 28 45 36 31 38 38 40 25 41 32 37 30 35 36 40 48 35 37 38 37 40 36 29 30 34 33 32 29 28 31 32 29 32 30 30 27 27 25 32 34 33 31 28 31 30 29 30 32 33 36 29 32 34 31 30 32 36 34 35 32 28 33 31 32 29 30 33 33 34 33 34 31 33 29 31 32 33 34 37 33 29 30 33 26 33 35 45 38 44 36 46 48 46 44 52 48 49 45 51 45 43 42 42 49 44 41 36 40 34 30 37 37 38 40 38 42 43 39 41 44 45 44 44 43 43 37 31 38 28 29 45 29 52 35 36 32 27 35 43 52 33 31 20 27 28 23 30 38 51 31 39 36 36 31 49 43 35 32 35 31 26 20 28 28 27 28 20 22 21 21 25 22 29 32 25 35 38 27 29 28 33 35 28 22 29 37 33 28 32 20 33 30 30 28 32 31 23 36 33 27 34 43 20 22 22 24 15 24 25 25 26 24 28 28 23 25 27 30 28 29 28 20 22 23 21 28 30 25 22 36 24 22 35 22 25 30 20 20 24 28 26 28 33 29 23 25 22 24 26 18 20 22 25 20 25 28 35 28 37 20 28 35 22 30 25 30 20 35 38 30 35 35 35 35 28 32 39 40 28 35 25 22 22 39 22 18 32 28 28 42 52 55 40 55 52 48 50 50 45 45 25 25 52 40 70 40 30 40 30 20 10 30 50 40 60 50 40 30 20 50 40 60 30 30 10 20 10 30 30 40 30 20 20 10 0 10 10 30 10 0 10 30 20 10 10 20 30 40 30 20 20 20 10 0 0 0 0 0 10 10 10 0 0 0 10 10 10 10 0 0 0 0 10 0 0 0 0 10 0 10 10 10 10 0 10 0 0 0 0 10 0 0 10 10 10 0 0 0 10 10 10 0 10 10}\
		   arachidic {60 61 63 78 80 70 56 64 83 52 65 62 79 79 75 60 75 70 75 78 83 86 89 74 82 60 63 63 64 62 68 70 72 72 69 70 67 65 66 75 64 65 61 65 54 61 71 69 65 56 69 67 72 53 57 60 51 70 55 49 69 60 70 57 68 68 60 72 62 55 68 70 68 65 51 44 60 69 65 66 56 46 46 50 48 67 72 60 62 60 65 70 60 60 60 50 54 50 69 57 44 43 70 51 58 68 45 41 48 48 50 50 52 70 32 65 76 54 51 56 56 48 74 64 60 60 60 50 42 52 49 59 74 66 55 56 52 65 60 64 80 76 60 64 54 46 59 73 50 55 51 62 68 69 59 51 57 54 69 52 56 56 64 64 60 63 51 65 59 50 50 46 58 53 67 43 63 51 50 52 56 48 64 53 45 52 58 54 60 50 58 59 65 51 59 63 61 45 58 53 66 60 60 50 59 48 63 54 61 62 54 52 49 44 57 55 68 65 69 66 74 64 62 61 70 65 75 61 55 72 67 68 76 62 66 63 69 61 57 55 56 53 57 53 63 60 64 61 57 62 64 57 59 60 93 83 94 69 91 83 88 95 69 67 65 65 68 64 77 59 64 71 74 84 87 86 78 72 77 97 93 101 89 64 69 70 62 69 63 76 73 70 71 60 42 69 75 56 62 62 87 66 72 60 50 70 82 70 80 40 52 68 58 61 59 78 102 59 53 73 72 62 58 98 90 94 94 92 66 66 62 62 61 67 61 75 68 83 75 65 62 68 72 82 64 67 90 58 81 68 89 67 77 78 74 59 73 53 78 66 71 65 80 83 74 80 77 79 87 56 83 61 95 79 58 90 74 72 66 67 57 62 71 68 77 82 61 79 72 46 47 45 70 68 90 85 72 86 74 69 105 73 66 88 65 65 74 88 96 57 85 67 75 81 68 76 69 60 75 84 71 50 55 47 20 42 55 55 65 50 65 50 55 53 40 40 34 42 32 42 34 45 36 38 56 52 33 42 50 45 45 44 58 59 35 23 27 32 20 65 55 15 20 48 20 60 50 60 20 35 10 40 100 70 80 80 90 50 20 60 100 90 100 100 90 90 70 100 90 80 80 70 20 70 30 50 80 70 80 90 70 40 20 30 60 60 30 10 30 90 70 40 50 60 80 60 70 70 40 50 30 20 10 0 0 10 10 40 20 0 0 0 0 10 40 0 0 0 0 0 10 0 10 0 10 10 0 0 10 10 0 0 0 0 10 0 0 20 0 10 0 10 0 10 10 0 10 10 10 0 10 20}\
		   eicosenoic {29 29 29 35 46 44 29 35 33 30 24 44 33 32 41 29 31 28 30 33 45 40 51 26 38 32 30 18 23 38 41 38 35 21 27 28 28 36 33 36 28 25 37 41 26 32 24 20 31 16 29 23 27 24 28 30 23 26 19 26 25 31 25 16 24 28 18 36 41 25 28 34 29 28 18 23 22 36 34 36 30 19 15 14 19 26 32 24 30 22 28 28 24 17 18 16 14 17 28 12 14 23 21 19 24 30 24 16 15 15 11 19 21 22 12 27 25 26 14 16 20 14 26 16 16 14 17 16 25 12 15 38 23 10 20 24 17 34 36 29 27 42 27 23 17 13 27 16 22 25 28 23 21 27 30 29 28 28 27 28 16 22 24 26 24 30 16 14 12 25 29 13 16 19 33 20 16 21 24 13 32 22 24 31 26 22 31 25 37 23 17 21 31 21 34 23 21 20 26 19 22 22 23 20 25 19 25 23 24 23 23 28 23 19 32 23 34 36 31 29 32 27 31 35 36 33 29 26 23 33 25 26 30 25 24 27 25 20 27 27 27 23 26 24 33 31 35 30 24 25 27 23 31 31 30 39 36 35 32 37 43 41 45 43 32 25 37 36 46 36 58 56 42 37 35 40 32 27 40 38 40 43 45 32 32 15 44 47 47 38 42 35 31 28 18 32 19 22 23 27 34 23 16 31 20 28 23 45 27 18 20 21 27 27 33 27 37 15 29 32 38 28 17 2 3 3 2 1 1 2 3 3 2 1 2 1 3 1 3 3 3 2 2 1 1 2 1 2 2 1 1 3 2 1 2 2 2 2 1 3 2 1 3 2 1 1 1 2 2 2 3 1 2 2 1 3 2 3 2 2 1 2 3 1 2 2 2 3 1 2 2 3 1 3 3 3 3 3 1 2 2 3 2 1 1 2 2 3 2 2 2 1 1 2 2 2 1 1 2 1 2 1 1 2 1 2 2 2 1 3 2 2 1 1 3 3 2 2 1 2 1 3 3 2 1 1 2 3 3 2 1 1 2 3 2 3 3 2 2 2 3 2 3 2 2 1 1 2 2 2 2 3 2 1 2 2 1 3 1 2 2 2 2 1 1 1 2 1 1 1 2 2 1 2 3 3 3 2 2 1 1 2 2 1 2 1 1 2 2 1 3 1 2 3 3 3 2 3 2 2 3 3 2 1 3 3 1 2 1 2 3 2 1 2 2 3 2 2 2 1 1 2 2 3 2 1 3 3 1 2 3 3 3 3 2 3 1 2 2 1 2 2 2 3 2 1 2 2 3 2 2 2}]

    ## Mamals data
    ## Brain and Body Weights for 62 Species of Land Mammals
    ## body: body weight in kg.
    ## brain: brain weight in g.
    ## name: Common name of species. (Rock hyrax-a = Heterohyrax brucci, Rock hyrax-b = Procavia habessinic..)
    ##
    ## Source: Weisberg, S. (1985) Applied Linear Regression. 2nd edition. Wiley, pp. 144–5.
    ## as seen in mammals data set in MASS R package
    
    set mammals [dict create\
		     body {3.385 0.48 1.35 465 36.33 27.66 14.83 1.04 4.19 0.425 0.101 0.92 1 0.005 0.06 3.5 2 1.7 2547 0.023 187.1 521 0.785 10 3.3 0.2 1.41 529 207 85 0.75 62 6654 3.5 6.8 35 4.05 0.12 0.023 0.01 1.4 250 2.5 55.5 100 52.16 10.55 0.55 60 3.6 4.288 0.28 0.075 0.122 0.048 192 3 160 0.9 1.62 0.104 4.235}\
		     brain {44.5 15.5 8.1 423 119.5 115 98.2 5.5 58 6.4 4 5.7 6.6 0.14 1 10.8 12.3 6.3 4603 0.3 419 655 3.5 115 25.6 5 17.5 680 406 325 12.3 1320 5712 3.9 179 56 17 1 0.4 0.25 12.5 490 12.1 175 157 440 179.5 2.4 81 21 39.2 1.9 1.2 3 0.33 180 25 169 2.6 11.4 2.5 50.4}\
		     name {{Arctic fox} {Owl monkey} {Mountain beaver} {Cow} {Grey wolf} {Goat} {Roe deer} {Guinea pig} {Verbet} {Chinchilla} {Ground squirrel} {Arctic ground squirrel} {African giant pouched rat} {Lesser short-tailed shrew} {Star-nosed mole} {Nine-banded armadillo} {Tree hyrax} {N.A. opossum} {Asian elephant} {Big brown bat} {Donkey} {Horse} {European hedgehog} {Patas monkey} {Cat} {Galago} {Genet} {Giraffe} {Gorilla} {Grey seal} {Rock hyrax-a} {Human} {African elephant} {Water opossum} {Rhesus monkey} {Kangaroo} {Yellow-bellied marmot} {Golden hamster} {Mouse} {Little brown bat} {Slow loris} {Okapi} {Rabbit} {Sheep} {Jaguar} {Chimpanzee} {Baboon} {Desert hedgehog} {Giant armadillo} {Rock hyrax-b} {Raccoon} {Rat} {E. American mole} {Mole rat} {Musk shrew} {Pig} {Echidna} {Brazilian tapir} {Tenrec} {Phalanger} {Tree shrew} {Red fox}}]
    
}
