% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_compound.R, R/l_pairs.R, R/l_plot_ts.R
\name{l_getLocations}
\alias{l_getLocations}
\alias{l_getLocations.l_pairs}
\alias{l_getLocations.l_ts}
\title{For the target compound loon plot, determines location (only and excluding the grobs)
arguments to pass to `gridExtra::arrangeGrob()`}
\usage{
l_getLocations(target)

\method{l_getLocations}{l_pairs}(target)

\method{l_getLocations}{l_ts}(target)
}
\arguments{
\item{target}{the (compound) loon  plot whose locations are needed lay it out.}
}
\value{
a list of an appropriate subset of the named location arguments
`c("ncol", "nrow", "layout_matrix", "heights", "widths")`.  There are as many heights and
 widths as there are plots returned by \code{l_getPlots()}; these specify
 the relative height and width of each plot in the display.  \code{layout_matrix}
 is an \code{nrow} by \code{ncol} matrix whose entries identify the location
 of each plot in \code{l_getPlots()} by their index.
}
\description{
For the target compound loon plot, determines location (only and excluding the grobs)
arguments to pass to `gridExtra::arrangeGrob()`
}
\examples{

if(interactive()) {

pp <- l_pairs(iris, showHistograms = TRUE)
ll <- l_getLocations(pp)
nplots <- length(l_getPlots(pp))
# the plots returned by l_getPlots(pp) are positioned
# in order by the layout_matrix
# ll$layout_matrix TODO
}

}
