% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lda.R
\name{lda}
\alias{lda}
\title{Longitudinal data analysis}
\usage{
lda(data_res, data_cov, N, bd, omit, method)
}
\arguments{
\item{data_res}{An object of class tibble. The structure of the tibble must be: $tibble(id_y=ID, ty=measurement time for response, y=observation for response, x=matrix(observation for synchronous covariates), x_add=matrix(observation for uninterested synchronous covariates))$.}

\item{data_cov}{An object of class tibble. The structure of the tibble must be: $tibble(id_z=ID, tz=measurement time for response, z=matrix(observation for asynchronous covariates))$.}

\item{N}{An object of class integer. The sample size.}

\item{bd}{An object of class vector. If use auto bandwidth selection, the structure of the vector must be: $bd=c(the maximum bandwidth, the minimum bandwidth, the fold of cross-validation, the number of bandwidth divided).$ If use fixed bandwidth, $bd=c(the chosen bandwidth).$}

\item{omit}{An object of class integer indicating the method used to do estimation for synchronous covariates. If use plm method, omit=1; if use centering method, omit=2; if use additional covariates information, omit=3.}

\item{method}{An object of class integer indicating the method used to do estimation for asynchronous covariates. If only deal with omit variable, method=0; if use two-stage method, method=1; if use kernel smoothing, method=2.}
}
\value{
a list with the following elements:
\item{est}{The estimation for the corresponding parameters.}
\item{se}{The estimation of standard error for the estimated parameters.}
}
\description{
This package provide regression analysis of mixed sparse synchronous and asynchronous longitudinal covariates.
}
\examples{

library(MASS)
library(tibble)
library(dplyr)
N=100
ty=tz=y=x=z=id_y=id_z=list()
a=b=g=1
ny=rpois(N,5)+1
nz=rpois(N,5)+1
for(i in 1:N){
  ty[[i]]=as.matrix(runif(ny[i]))
  tz[[i]]=as.matrix(runif(nz[i]))
  t.temp=rbind(tz[[i]],ty[[i]])
  n.temp=nz[i]+ny[i]
  corr=exp(-abs(rep(1,n.temp)\%*\%t(t.temp)-t.temp\%*\%t(rep(1,n.temp))))
  corr.e=2^(-abs(rep(1,n.temp)\%*\%t(t.temp)-t.temp\%*\%t(rep(1,n.temp))))
  MX=t.temp^.5
  MZ=rep(0, n.temp)
  x.temp=mvrnorm(1,MX,corr)
  z.temp=mvrnorm(1,MZ, corr)
  z[[i]]=as.matrix(z.temp[1:nz[i]])
  x[[i]]=as.matrix(x.temp[-(1:nz[i])])
  id_z[[i]]=rep(i,nz[i])
  id_y[[i]]=rep(i,ny[i])
  y.temp=a+g*z.temp+x.temp*b+as.matrix(mvrnorm(1,rep(0,n.temp),corr.e))
  y[[i]]=as.matrix(y.temp[-(1:nz[i])])
}
data_cov=tibble(id_z=unlist(id_z),tz=unlist(tz),z=matrix(unlist(z),length(unlist(z))))
data_res=tibble(id_y=unlist(id_y),ty=unlist(ty),x=matrix(unlist(x),length(unlist(x))),y=unlist(y))
bd=0.1
omit=1
method=1
lda(data_res,data_cov,N,bd,omit,method)
}
