% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazard.R
\name{hazard_elife}
\alias{hazard_elife}
\title{Profile likelihood for hazard}
\usage{
hazard_elife(
  x,
  time,
  time2 = NULL,
  event = NULL,
  status = NULL,
  thresh = 0,
  ltrunc = NULL,
  rtrunc = NULL,
  type = c("right", "left", "interval", "interval2"),
  family = c("exp", "gp", "gomp", "weibull", "extgp"),
  weights = rep(1, length(time)),
  level = 0.95,
  psi = NULL,
  plot = FALSE,
  arguments = NULL,
  ...
)
}
\arguments{
\item{x}{value of the threshold exceedance at which to estimate the hazard}

\item{time}{excess time of the event of follow-up time, depending on the value of event}

\item{time2}{ending excess time of the interval for interval censored data only.}

\item{event}{status indicator, normally 0=alive, 1=dead. Other choices are \code{TRUE}/\code{FALSE} (\code{TRUE} for death).
For interval censored data, the status indicator is 0=right censored, 1=event at time, 2=left censored, 3=interval censored.
Although unusual, the event indicator can be omitted, in which case all subjects are assumed to have experienced an event.}

\item{status}{integer vector giving status of an observation. If \code{NULL} (default), this argument is computed internally based on \code{type}.}

\item{thresh}{vector of thresholds}

\item{ltrunc}{lower truncation limit, default to \code{NULL}}

\item{rtrunc}{upper truncation limit, default to \code{NULL}}

\item{type}{character string specifying the type of censoring. Possible values are "\code{right}", "\code{left}", "\code{interval}", "\code{interval2}".}

\item{family}{string; choice of parametric family}

\item{weights}{weights for observations}

\item{level}{numeric; the level for the confidence intervals. Default to 0.95}

\item{psi}{optional vector of hazard at which to compute the profile log likelihood}

\item{plot}{logical; if true, display the profile log-likelihood. Default to \code{FALSE}.}

\item{arguments}{a named list specifying default arguments of the function that are common to all \code{elife} calls}

\item{...}{additional arguments for optimization, currently ignored.}
}
\value{
an invisible object of class \code{elife_hazard} containing information about the profile likelihood
}
\description{
This function computes the hazard for different \code{elife} parametric
models with profile-likelihood based confidence intervals.
It is also used to provide local hazard plots at varying thresholds.
}
\examples{
n <- 2500
time <- samp_elife(n = n, scale = 2,
family = "gp", shape = 0.1,
lower = ltrunc <- runif(n),
upper = rtrunc <- (5 + runif(n)), type2 = "ltrt")
hazard_elife(x = 2, time = time,
 ltrunc = ltrunc, rtrunc = rtrunc, family = "exp")
}
\keyword{internal}
