% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_addgenes.R
\name{gg_addgenes}
\alias{gg_addgenes}
\title{Add gene tracks to a ggplot2 plot}
\usage{
gg_addgenes(p, loc, heights = c(3, 2), ...)
}
\arguments{
\item{p}{ggplot2 plot object. This can be generated by \code{\link[=gg_scatter]{gg_scatter()}} and
then modified.}

\item{loc}{Object of class 'locus' to use for plot. See \code{\link[=locus]{locus()}}.}

\item{heights}{Vector specifying ratio of heights of upper plot and lower
gene track.}

\item{...}{Additional arguments passed to \code{\link[=gg_genetracks]{gg_genetracks()}} to control
colours of gene tracks etc.}
}
\value{
A ggplot2 plotting object.
}
\description{
Adds gene tracks to an existing ggplot2 plot.
}
\examples{
if(require(EnsDb.Hsapiens.v75)) {
data(SLE_gwas_sub)
loc <- locus(SLE_gwas_sub, gene = 'IRF5', flank = c(7e4, 2e5), LD = "r2",
             ens_db = "EnsDb.Hsapiens.v75")
p <- gg_scatter(loc)
gg_addgenes(p, loc)
}
}
\seealso{
\code{\link[=gg_scatter]{gg_scatter()}} \code{\link[=gg_genetracks]{gg_genetracks()}}
}
