% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/rMethods.R
\name{localScoreC}
\alias{localScoreC}
\alias{localScoreC_double}
\alias{localScoreC_int}
\title{Local score}
\usage{
localScoreC(v, suppressWarnings = FALSE)

localScoreC_double(v, suppressWarnings = FALSE)

localScoreC_int(v, suppressWarnings = FALSE)
}
\arguments{
\item{v}{a sequence of numerical values as vector (integer or double).}

\item{suppressWarnings}{(optional) if warnings should not be displayed}
}
\value{
A list containing:
\item{localScore}{the local score value and the begin and end index of the segment realizing this optimal score;}
\item{suboptimalSegmentScores}{An array containing sub-optimal local scores, that is all the local maxima of the Lindley rocess (non negative excursion) and their begin and end index;}
\item{RecordTime}{The record times of the Lindley process as defined in Karlin and Dembo (1990).}
}
\description{
Calculates the local score for a sequence of scores, the sub-optimal segments, and the associated record times. The local score is the maximal sum of values contained in a segment among all possible segments of the sequence. In other word, it generalizes a sliding window approach, considering of all possible windows size.
}
\details{
The \code{localScoreC} function is implemented in a templated C function. Be aware that the type of the output (\code{integer} or \code{double}) depends on the type of the input. The function \code{localScoreC_double} \code{localScoreC_int} explicitly use the corresponding type (with an eventual conversion in case of integer). Warning: in R, \code{typeof(c(1,3,4,10)) == "double"}. You can set a type of a vector with \code{mode()} or \code{as.integer()} functions for example. \cr
\code{localScoreC_int} is just a call to \code{as.integer()} before calling \code{localScoreC}. \code{localScore_double} is just a call to \code{localScoreC}, and as such is deprecated.
}
\examples{
localScoreC(c(1.2,-2.1,3.5,1.7,-1.1,2.3))
# one segment realizing the local score value
seq.OneSegment <- c(1,-2,3,1,-1,2)
localScoreC(seq.OneSegment) 
seq.TwoSegments <- c(1,-2,3,1,2,-2,-2,-1,1,-2,3,1,2,-1,-2,-2,-1,1)
# two segments realizing the local score value
localScoreC(seq.TwoSegments) 
# only the first realization
localScoreC(seq.TwoSegments)$localScore 
# all the realization of the local together with the suboptimal ones
localScoreC(seq.TwoSegments)$suboptimalSegmentScores 
# for small sequences, you can also use lindley() function to check if 
# several segments achieve the local Score
lindley(seq.TwoSegments) 
plot(1:length(seq.TwoSegments),lindley(seq.TwoSegments),type='b')
seq.TwoSegments.InSameExcursion <- c(1,-2,3,2,-1,0,1,-2,-2,-4,1)
localScoreC(seq.TwoSegments.InSameExcursion)
# lindley() shows two realizations in the same excursion (no 0 value between the two LS values)
lindley(seq.TwoSegments.InSameExcursion) 
# same beginning index but two possible ending indexes
# only one excursion realizes the local score even in there is two possible lengths of segment
localScoreC(seq.TwoSegments.InSameExcursion)$suboptimalSegmentScores 
plot(1:length(seq.TwoSegments.InSameExcursion),lindley(seq.TwoSegments.InSameExcursion),type='b')
# Technical note about type correspondance
seq.OneSegment <- c(1,-2,3,1,-1,2)
seq.OneSegmentI <- as.integer(seq.OneSegment)
typeof(seq.OneSegment)  # "double" (beware)
typeof(seq.OneSegmentI) # "integer"
LS1 <- localScoreC(seq.OneSegment, suppressWarnings = TRUE)
LS1I <- localScoreC(seq.OneSegmentI, suppressWarnings = TRUE)
typeof(LS1$localScore)  # "double"
typeof(LS1I$localScore) # "integer"
typeof(LS1$suboptimalSegmentScores$value)  # "double"
typeof(LS1I$suboptimalSegmentScores$value) # "integer"
# Force to use integer values (trunk values if necessary)
seq2 <- seq.OneSegment + 0.5
localScoreC(seq2, suppressWarnings = TRUE)
localScoreC_int(seq.OneSegment, suppressWarnings = TRUE)
}
\seealso{
\code{\link{lindley}}
}
