% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_lme4.R, R/bootstrap_nlme.R,
%   R/generics.R
\name{case_bootstrap.merMod}
\alias{case_bootstrap.merMod}
\alias{case_bootstrap.lme}
\alias{case_bootstrap}
\title{Cases Bootstrap for Nested LMEs}
\usage{
\method{case_bootstrap}{merMod}(model, .f, B, resample)

\method{case_bootstrap}{lme}(model, .f, B, resample)

case_bootstrap(model, .f, B, resample)
}
\arguments{
\item{model}{The model object you wish to bootstrap.}

\item{.f}{A function returning the statistic(s) of interest.}

\item{B}{The number of bootstrap resamples.}

\item{resample}{A logical vector specifying whether each level of the model 
should be resampled in the cases bootstrap. The levels should be specified 
from the highest level (largest cluster) of the hierarchy to the lowest 
(observation-level); for example for students within a school, specify the 
school level first, then the student level.}
}
\value{
The returned value is an object of class "lmeresamp".
}
\description{
Generate cases bootstrap replicates of a statistic for a nested linear 
mixed-effects model.
}
\details{
The cases bootstrap is a fully nonparametric bootstrap that resamples the data
with respect to the clusters in order to generate bootstrap samples. Depending 
on the nature of the data, the resampling can be done only for the higher-level 
cluster(s), only at the observation-level within a cluster, or at all levels.
See Van der Leeden et al. (2008) for a nice discussion of this decision. 

To resample a given level of the model, the corresponding entry in the logical 
vector specified in the \code{resample} parameter must be set to true. A few
examples are given below in terms of a two-level model where students are
clustered within schools:

\itemize{
  \item To resample only the schools, set \code{resample = c(TRUE, FALSE)}.
  \item To resample only the students, set \code{resample = c(FALSE, TRUE)}.
  \item To resample both the students and the schools, set \code{resample = c(TRUE, TRUE)}.
}
}
\references{
Van der Leeden, R., Meijer, E. and Busing F. M. (2008) Resampling multilevel 
   models. In J. de Leeuw and E. Meijer, editors, \emph{Handbook of 
   Multilevel Analysis}, pages 401--433. New York: Springer.
}
\seealso{
\itemize{
  \item Examples are given in \code{\link{bootstrap}}
  \item \code{\link{parametric_bootstrap}}, \code{\link{resid_bootstrap}},
     \code{\link{case_bootstrap}}, \code{\link{reb_bootstrap}}, 
     \code{\link{wild_bootstrap}} for more details on a specific bootstrap.
  \item \code{\link[lme4]{bootMer}} in the \pkg{lme4} package for an 
     implementation of (semi-)parametric bootstrap for mixed models.
}
}
