% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information-matrices.R
\name{extract_varcomp}
\alias{extract_varcomp}
\title{Extract estimated variance components}
\usage{
extract_varcomp(mod, separate_variances, vector)
}
\arguments{
\item{mod}{Fitted model of class lmeStruct or glsStruct.}

\item{separate_variances}{Logical indicating whether to return the separate
level-1 variance components for each stratum if using \code{varIdent}
function to allow for different variances per stratum. Default is
\code{FALSE}.}

\item{vector}{Logical indicating whether to return the variance components as
a numeric vector. Default is \code{FALSE}.}
}
\value{
If \code{vector = FALSE}, an object of class \code{varcomp} consisting of a
  list of estimated variance components. Models that do not include
  correlation structure parameters or variance structure parameters will have
  empty lists for those components. If \code{vector = TRUE}, a numeric vector
  of estimated variance components.

  If \code{separate_variances = TRUE} and if \code{weights =
  varIdent(form = ~ 1 | Stratum)} is specified in the model fitting, separate
  level-1 variance estimates will be returned for each stratum. If
  \code{separate_variances = TRUE} but if the weighting structure is not
  specified with \code{varIdent}, or if \code{separate_variances = FALSE},
  then no separate level-1 variance estimates will be returned.
}
\description{
Extracts the estimated variance components from a fitted linear
  mixed effects model (lmeStruct object) or generalized least squares model
  (glsStruct object).
}
\examples{

library(nlme)
data(Bryant2016)
Bryant2016_RML <- lme(fixed = outcome ~ treatment,
                      random = ~ 1 | school/case,
                      correlation = corAR1(0, ~ session | school/case),
                      weights = varIdent(form = ~ 1 | treatment),
                      data = Bryant2016)
extract_varcomp(Bryant2016_RML, separate_variances = FALSE)
extract_varcomp(Bryant2016_RML, separate_variances = TRUE)
extract_varcomp(Bryant2016_RML, vector = TRUE)

}
