% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqDGP.R
\name{basisCompute.lineqDGP}
\alias{basisCompute.lineqDGP}
\title{Basis Functions for \code{"lineqDGP"} Models}
\usage{
basisCompute.lineqDGP(x, m, d = 1, constrType = c("boundedness",
  "monotonicity", "convexity"))
}
\arguments{
\item{x}{a vector with the input data.}

\item{m}{the number of basis functions used in the approximation.}

\item{d}{a number corresponding to the dimension of the input space.}

\item{constrType}{a character string corresponding to the type of the inequality constraint.
Options: "boundedness", "monotonicity", "convexity".}
}
\value{
A matrix with the basis functions. The basis functions are indexed by rows.
}
\description{
Evaluate the basis functions for \code{"lineqDGP"} models.
}
\examples{
x <- seq(0, 1, 0.01)
Phib <- basisCompute.lineqDGP(x, m = 5, constrType = "boundedness")
matplot(Phib, type = "l", lty = 2,
        main = "Basis functions for boundedness constraints")
Phim <- basisCompute.lineqDGP(x, m = 5, constrType = "monotonicity")
matplot(Phim, type = "l", lty = 2,
        main = "Basis functions for monotonicity constraints")
Phic <- basisCompute.lineqDGP(x, m = 5, constrType = "convexity")
matplot(Phic, type = "l", lty = 2,
        main = "Basis functions for convexity constraints")

}
\references{
Maatouk, H. and Bay, X. (2017),
"Gaussian process emulators for computer experiments with inequality constraints".
\emph{Mathematical Geosciences},
49(5):557-582.
\href{https://link.springer.com/article/10.1007/s11004-017-9673-2}{[link]}
}
\author{
A. F. Lopez-Lopera.
}
