% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqDGP.R
\name{create.lineqDGP}
\alias{create.lineqDGP}
\title{Creation Method for the \code{"lineqDGP"} S3 Class}
\usage{
\method{create}{lineqDGP}(x, y, constrType = c("boundedness",
  "monotonicity", "convexity"))
}
\arguments{
\item{x}{a vector or matrix with the input data. The dimensions should be indexed by columns.}

\item{y}{a vector with the output data.}

\item{constrType}{a character string (or list) corresponding to the type(s)
of inequality constraint(s).
Options: "boundedness", "monotonicity", "convexity", "linear".}
}
\value{
A list with the following elements.
\item{x,y,constrType}{see \bold{Arguments}.}
\item{d}{a number corresponding to the input dimension.}
\item{localParam}{a list with specific parameters required for \code{"lineqGP"} models:
\code{m} (number of basis functions), \code{sampler}, and \code{samplingParams}.
See \code{\link{simulate.lineqDGP}}.}
\item{kernParam}{a list with the kernel parameters:
\code{par} (kernel parameters), \code{type}, \code{nugget}.
See \code{\link{kernCompute}}}
\item{bounds}{the limit values if \code{constrType = "boundedness"}.}
}
\description{
Creation method for the \code{"lineqDGP"} S3 class.
}
\examples{
# creating the model
sigfun <- function(x) return(1/(1+exp(-7*(x-0.5))))
x <- seq(0, 1, length = 5)
y <- sigfun(x)
model <- create(class = "lineqDGP", x, y, constrType = "monotonicity")
model

}
\references{
Maatouk, H. and Bay, X. (2017),
"Gaussian process emulators for computer experiments with inequality constraints".
\emph{Mathematical Geosciences},
49(5):557-582.
\href{https://link.springer.com/article/10.1007/s11004-017-9673-2}{[link]}
}
\seealso{
\code{\link{augment.lineqDGP}}, \code{\link{predict.lineqDGP}},
         \code{\link{simulate.lineqDGP}}
}
\author{
A. F. Lopez-Lopera.
}
