% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/event_metrics.R
\name{event_overlaps}
\alias{event_overlaps}
\title{Event Overlaps}
\usage{
event_overlaps(e)
}
\arguments{
\item{e}{An event table.}
}
\value{
An endpoint-only event table with column "n" listing the number of overlapping events on that interval.
}
\description{
Returns the number of events on each interval. Useful for sampling the original data with \code{\link{sample_events}} at the highest possible resolution that nevertheless flattens overlapping events.
}
\details{
Point events are preserved and line events are cut as necessary at the endpoints of other point or line events.
}
\examples{
e <- events(c(0, 10, 15, 25, 30), c(10, 20, 25, 40, 30))
event_overlaps(e)
}
\seealso{
\code{\link{event_coverage}}.
}

