% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{interactive_text_explanations}
\alias{interactive_text_explanations}
\alias{text_explanations_output}
\alias{render_text_explanations}
\title{Interactive explanations}
\usage{
interactive_text_explanations(explainer,
  window_title = "Text model explainer",
  title = "Local Interpretable Model-agnostic Explanations",
  place_holder = "Put here the text to explain", minimum_lentgh = 3,
  minimum_lentgh_error = "Text provided is too short to be explained (>= 3).",
  max_feature_to_select = 20)

text_explanations_output(outputId, width = "100\%", height = "400px")

render_text_explanations(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{explainer}{parameters}

\item{window_title, title, place_holder, minimum_lentgh_error}{text to be displayed on the page}

\item{minimum_lentgh}{don't update display if text is shorter than this parameter}

\item{max_feature_to_select}{up limit to the number of words that can be selected}

\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit or a number, which will be coerced to a string and have "px" appended.}

\item{expr}{An expression that generates an HTML widget}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{\link[=quote]{quote()}})? This
is useful if you want to save an expression in a variable.}
}
\value{
An output function that enables the use of the widget within Shiny applications.

A render function that enables the use of the widget within Shiny applications.
}
\description{
Display text explanation in an interactive way.
You can :

Create an output to insert text explanation plot in Shiny application.

Render the text explanations in Shiny application.
}
\details{
\itemize{
\item send a new sentence
\item update the parameters of the explainer
}
}
\examples{
library(text2vec)
library(xgboost)

data(train_sentences)
data(test_sentences)

get_matrix <- function(text) {
  it <- itoken(text, progressbar = FALSE)
  create_dtm(it, vectorizer = hash_vectorizer())
}

dtm_train = get_matrix(train_sentences$text)

xgb_model <- xgb.train(list(max_depth = 7, eta = 0.1, objective = "binary:logistic",
                 eval_metric = "error", nthread = 1),
                 xgb.DMatrix(dtm_train, label = train_sentences$class.text == "OWNX"),
                 nrounds = 50)

sentences <- head(test_sentences[test_sentences$class.text == "OWNX", "text"], 1)
explainer <- lime(train_sentences$text, xgb_model, get_matrix)

# The explainer can now be queried interactively:
\dontrun{
interactive_text_explanations(explainer)
}
}
