% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveRDS.lgb.Booster.R
\name{saveRDS.lgb.Booster}
\alias{saveRDS.lgb.Booster}
\title{saveRDS for \code{lgb.Booster} models (DEPRECATED)}
\usage{
saveRDS.lgb.Booster(
  object,
  file,
  ascii = FALSE,
  version = NULL,
  compress = TRUE,
  refhook = NULL,
  raw = TRUE
)
}
\arguments{
\item{object}{\code{lgb.Booster} object to serialize.}

\item{file}{a connection or the name of the file where the R object is saved to or read from.}

\item{ascii}{a logical. If TRUE or NA, an ASCII representation is written; otherwise (default),
a binary one is used. See the comments in the help for save.}

\item{version}{the workspace format version to use. \code{NULL} specifies the current default
version (2). Versions prior to 2 are not supported, so this will only be relevant
when there are later versions.}

\item{compress}{a logical specifying whether saving to a named file is to use "gzip" compression,
or one of \code{"gzip"}, \code{"bzip2"} or \code{"xz"} to indicate the type of
compression to be used. Ignored if file is a connection.}

\item{refhook}{a hook function for handling reference objects.}

\item{raw}{whether to save the model in a raw variable or not, recommended to leave it to \code{TRUE}.}
}
\value{
NULL invisibly.
}
\description{
Calls \code{saveRDS} on an \code{lgb.Booster} object, making it serializable before the call if
             it isn't already.

             \bold{This function throws a warning and will be removed in future versions.}
}
\examples{
\donttest{
library(lightgbm)
\dontshow{setLGBMthreads(2L)}
\dontshow{data.table::setDTthreads(1L)}
data(agaricus.train, package = "lightgbm")
train <- agaricus.train
dtrain <- lgb.Dataset(train$data, label = train$label)
data(agaricus.test, package = "lightgbm")
test <- agaricus.test
dtest <- lgb.Dataset.create.valid(dtrain, test$data, label = test$label)
params <- list(
  objective = "regression"
  , metric = "l2"
  , min_data = 1L
  , learning_rate = 1.0
  , num_threads = 2L
)
valids <- list(test = dtest)
model <- lgb.train(
    params = params
    , data = dtrain
    , nrounds = 10L
    , valids = valids
    , early_stopping_rounds = 5L
)
model_file <- tempfile(fileext = ".rds")
saveRDS.lgb.Booster(model, model_file)
}
}
