% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_logging.R
\name{basic_config}
\alias{basic_config}
\title{Basic Setup for the Logging System}
\usage{
basic_config(file = NULL, fmt = "\%L [\%t] \%m",
  timestamp_fmt = "\%Y-\%m-\%d \%H:\%M:\%OS3", threshold = "info",
  appenders = NULL, console = if (is.null(appenders)) "all" else FALSE,
  console_fmt = "\%L [\%t] \%m \%f",
  console_timestamp_fmt = "\%H:\%M:\%OS3", memory = FALSE)
}
\arguments{
\item{file}{\code{character} scalar: If not \code{NULL} a \link{AppenderFile} will be
created that logs to this file. If the filename ends in \code{.jsonl}, the
Appender will be set up to use the \href{http://jsonlines.org/}{JSON Lines} format instead of plain text (see
\link{AppenderFile} and \link{AppenderJson}).}

\item{fmt}{\code{character} scalar: Format to use if \code{file} is supplied and not a
\code{.jsonl} file. If \code{NULL} it defaults to \code{"\%L [\%t] \%m"} (see
\link{format.LogEvent})}

\item{timestamp_fmt}{see \code{\link[=format.POSIXct]{format.POSIXct()}}}

\item{threshold}{\code{character} or \code{integer} scalar. The minimum \link[=log_levels]{log level} that should be processed by the root logger.}

\item{appenders}{a single \link{Appender} or a list thereof.}

\item{console}{\code{logical} scalar or a \code{threshold} (see above). Add an appender
logs to the console (i.e. displays messages in an interactive R session)}

\item{console_fmt}{\code{character} scalar: like \code{fmt} but used for console output}

\item{console_timestamp_fmt}{\code{character} scalar: like \code{timestamp_fmt} but
used for console output}

\item{memory}{\code{logical} scalar. or a \code{threshold} (see above). Add an Appender
that logs to a memory buffer, see also \code{\link[=show_log]{show_log()}} and \link{AppenderBuffer}}
}
\value{
the \code{root} Logger (lgr)
}
\description{
Quick and easy way to configure the root logger for logging to a file.
}
