% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-logging.R
\name{suspend_logging}
\alias{suspend_logging}
\alias{unsuspend_logging}
\alias{without_logging}
\alias{with_logging}
\title{Suspend All Logging}
\usage{
suspend_logging()

unsuspend_logging()

without_logging(code)

with_logging(code)
}
\arguments{
\item{code}{Any \R code}
}
\value{
\code{suspend_logging()} and \code{unsuspend_logging()} return \code{NULL} (invisibly),
\code{without_logging()} and \code{with_logging()} returns whatever \code{code} returns.
}
\description{
Completely disable logging for all loggers. This is for example useful for
automated test code. \code{suspend_logging()} globally disables all logging with
lgr until \code{unsuspend_logging()} is invoked, while \code{without_logging()} and
\code{with_logging()} temporarily disable/enable logging.
}
\examples{
lg <- get_logger("test")

# temporarily disable logging
lg$fatal("foo")
without_logging({
  lg$info("everything in this codeblock will be suppressed")
  lg$fatal("bar")
})

# globally disable logging
suspend_logging()
lg$fatal("bar")
with_logging(lg$fatal("foo"))  # log anyways

# globally enable logging again
unsuspend_logging()
lg$fatal("foo")
}
