% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main-plot_pred.R
\name{plot_components}
\alias{plot_components}
\title{Visualize all model components}
\usage{
plot_components(
  fit,
  pred = NULL,
  group_by = "id",
  t_name = "age",
  MULT_STD = 2,
  verbose = TRUE,
  draws = NULL,
  reduce = function(x) base::mean(x),
  color_by = NA,
  no_err = FALSE,
  ylim = NULL,
  draw = TRUE,
  nrow = NULL,
  ncol = NULL,
  gg_add = NULL,
  x = NULL,
  ...
)
}
\arguments{
\item{fit}{An object of class \linkS4class{lgpfit}.}

\item{pred}{An object of class \linkS4class{GaussianPrediction} or
\linkS4class{Prediction}. If \code{pred=NULL}, the \code{\link{pred}}
function is called with the given \code{reduce} and \code{draws} arguments.}

\item{group_by}{name of the grouping variable (use \code{group_by=NA}
to avoid grouping)}

\item{t_name}{name of the x-axis variable}

\item{MULT_STD}{a multiplier for standard deviation}

\item{verbose}{Can this print any messages?}

\item{draws}{Only has effect if \code{pred=NULL}.}

\item{reduce}{Only has effect if \code{pred=NULL}.}

\item{color_by}{Names of coloring factors. Can have length 1 or equal to
the number of components. See the \code{color_by} argument of
\code{\link{plot_f}}.}

\item{no_err}{Should the error ribbons be skipped even though they
otherwise would be shown? Can have length 1 or equal to number of
components + 1. See the \code{no_err} argument of \code{\link{plot_api_c}}.}

\item{ylim}{a vector of length 2 (upper and lower y-axis limits), or NULL}

\item{draw}{if this is TRUE, the plot grid is drawn using
\code{\link[gridExtra]{arrangeGrob}}}

\item{nrow}{number of grid rows}

\item{ncol}{number of grid columns}

\item{gg_add}{additional ggplot obejct to add to each plot}

\item{x}{Deprecated argument. This is now taken from the \code{pred}
object to ensure compatibility.}

\item{...}{additional arguments to \code{\link{plot_api_c}}}
}
\value{
a list of ggplot objects invisibly
}
\description{
This calls \code{\link{plot_f}} for all model components.
}
\seealso{
Other main plot functions: 
\code{\link{plot_draws}()},
\code{\link{plot_pred}()}
}
\concept{main plot functions}
