% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/lgcpStructures.R
\name{segProbs}
\alias{segProbs}
\title{segProbs function}
\usage{
segProbs(obj, domprob)
}
\arguments{
\item{obj}{an lgcpPredictMultitypeSpatialPlusParameters object}

\item{domprob}{the threshold beyond which we declare a type as dominant e.g. a value of 0.8 would mean we would consider each type to be dominant if the
conditional probability of an event of a given type at that location exceeded 0.8.}
}
\value{
an lgcpgrid object contatining the segregation probabilities.
}
\description{
A function to compute segregation probabilities from a multivariate LGCP. See the vignette "Bayesian_lgcp" for a full explanation of this.\cr
}
\details{
We suppose there are K point types of interest. The model for point-type k is as follows:\cr
\cr
X_k(s) ~ Poisson[R_k(s)]\cr
\cr
R_k(s) = C_A lambda_k(s) exp[Z_k(s)beta_k+Y_k(s)]\cr
\cr

Here X_k(s) is the number of events of type k in the computational grid cell containing the
point s, R_k(s) is the Poisson rate, C_A is the cell area, lambda_k(s) is a known offset, Z_k(s) is a vector
of measured covariates and Y_i(s) where i = 1,...,K+1 are latent Gaussian processes on the
computational grid. The other parameters in the model are beta_k , the covariate effects for the
kth type; and eta_i = [log(sigma_i),log(phi_i)], the parameters of the process Y_i for i = 1,...,K+1 on
an appropriately transformed (again, in this case log) scale.

The term 'conditional probability of type k' means the probability that at a particular location, x, there
will be an event of type k, we denote this p_k(x).

It is also of interest to scientists to be able to illustrate spatial regions where a genotype
dominates a posteriori. We say that type k dominates at position x if p_k(x)>c, where c (the parameter domprob) is a
threshold is a threshold set by the user. Let A_k(c,q) denote the set of locations x for which P[p_k(x)>c|X] > q.

As the quantities c and q tend to 1 each area A_k(c,p) shrinks towards the empty set; this
happens more slowly in a highly segregated pattern compared with a weakly segregated one.

The function segProbs computes P[p_k(x)>c|X] for each type, from which plots of P[p_k(x)>c|X] > q can be produced.
}

