## ---- include=FALSE---------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(fig.width=4.5, fig.height=4)

## ----include=FALSE----------------------------------------------------------------------------------------------------
suppressPackageStartupMessages(library("lessR"))

## ----read-------------------------------------------------------------------------------------------------------------
d <- Read("Employee")

## ----sp, fig.width=4.5------------------------------------------------------------------------------------------------
Plot(Years, Salary)

## ----spEnhance, fig.width=4.5-----------------------------------------------------------------------------------------
Plot(Years, Salary, enhance=TRUE)

## ----sploess, fig.width=4.5-------------------------------------------------------------------------------------------
Plot(Years, Salary, fit="loess", plot_errors=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
Plot(Dept, Gender)

## ---------------------------------------------------------------------------------------------------------------------
Plot(Gender, Salary)

## ----size, fig.width=4.5----------------------------------------------------------------------------------------------
Plot(Years, Salary, size=Pre)

## ----by, fig.width=6--------------------------------------------------------------------------------------------------
Plot(Years, Salary, by=Gender)

## ---- fig.width=4.5, fig.height=4-------------------------------------------------------------------------------------
Plot(Years, Salary, by1=Gender)

## ---- fig.width=6, fig.height=5---------------------------------------------------------------------------------------
Plot(Years, Salary, by1=Dept, by2=Gender, by=Plan, fit="lm")

## ----three, fig.width=5, fig.height=4---------------------------------------------------------------------------------
Plot(c(Pre, Post), Salary, fit="lm", fit_se=0)

## ----spmat, , fig.width=5, fig.height=5-------------------------------------------------------------------------------
Plot(c(Salary, Years, Pre, Post), fit=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
x <- rnorm(5000)
y <- rnorm(5000)
Plot(x, y)

## ---------------------------------------------------------------------------------------------------------------------
Plot(x, y, smooth=FALSE, trans=.97, theme="slatered")

## ---------------------------------------------------------------------------------------------------------------------
Plot(Salary)

## ---------------------------------------------------------------------------------------------------------------------
Plot(Salary, run=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
Plot(Dept)

## ---- fig.height=5.5, fig.width=4.5-----------------------------------------------------------------------------------
Plot(Salary, row_names)

## ---- fig.height=5.5, fig.width=4.5-----------------------------------------------------------------------------------
Plot(Salary, row_names, sort_yx="0", segments_y=FALSE)

## ---- fig.width=5, fig.height=5.5-------------------------------------------------------------------------------------
Plot(c(Pre, Post), row_names)

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("StockPrice")
d[1:5,]

## ---------------------------------------------------------------------------------------------------------------------
Plot(date, Price, rows=(Company=="Apple"))

## ---- fig.width=5-----------------------------------------------------------------------------------------------------
Plot(date, Price, by=Company)

## ---- fig.width=5-----------------------------------------------------------------------------------------------------
Plot(date, Price, by=Company, stack=TRUE)

## ---- fig.width=4.5---------------------------------------------------------------------------------------------------
Plot(date, Price, by1=Company)

## ---- fig.width=4.5---------------------------------------------------------------------------------------------------
style(sub_theme="black", window_fill="gray10")
Plot(date, Price, by1=Company, n_col=1,  fill="darkred", color="red", trans=.55)
style()

## ---- fig.wdith=6.5---------------------------------------------------------------------------------------------------
Plot(date, Price, by=Company, trans=0.4, stack=TRUE, area_fill="emeralds")

## ---------------------------------------------------------------------------------------------------------------------
dw <- reshape(d, direction = "wide",
        idvar = "date", timevar = "Company",
        varying = list(c("Apple", "IBM", "Intel")))
head(dw)

## ---- fig.wdith=6.5---------------------------------------------------------------------------------------------------
Plot(date, c(Intel, Apple, IBM), area_fill="blues", stack=TRUE, trans=.4, data=dw)

## ---- fig.wdith=5-----------------------------------------------------------------------------------------------------
a1.ts <- ts(dw$Apple, frequency=12, start=c(1980, 12))
Plot(a1.ts)

## ---------------------------------------------------------------------------------------------------------------------
style()

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("Employee", quiet=TRUE)

## ----fig.width=4.5----------------------------------------------------------------------------------------------------
Plot(Years, Salary, add=c("Hi", "Bye", "Wow"), x1=c(12, 16, 18),
  y1=c(80000, 100000, 60000))

## ----fig.width=4.5----------------------------------------------------------------------------------------------------
style(add_trans=.8, add_fill="gold", add_color="gold4", add_lwd=0.5)
Plot(Years, Salary, add="rect", x1=12, y1=80000, x2=16, y2=115000)

