## ---------------------------------------------------------------------------------------------------------------------
library("lessR")

## ---------------------------------------------------------------------------------------------------------------------
Prop_test(n_succ=682, n_fail=243, p0=.75)

## ----read-------------------------------------------------------------------------------------------------------------
d <- Read("Employee")

## ---------------------------------------------------------------------------------------------------------------------
Prop_test(variable=Gender, success="F")

## ---------------------------------------------------------------------------------------------------------------------
prop(Gender, "F", p0=0.6)

## ---------------------------------------------------------------------------------------------------------------------
smokers <- c(83, 90, 129, 70)
patients <- c(86, 93, 136, 82)
Prop_test(n_succ=smokers, n_tot=patients)

## ---------------------------------------------------------------------------------------------------------------------
smokers <- c(83, 90, 129, 70)
names(smokers) <- c("Group1","Group2","Group3","Group4")
patients <- c(86, 93, 136, 82)
Prop_test(n_succ=smokers, n_tot=patients)

## ---------------------------------------------------------------------------------------------------------------------
sm1 <- c(rep("smoke", 83), rep("nosmoke", 3))
sm2 <- c(rep("smoke", 90), rep("nosmoke", 3))
sm3 <- c(rep("smoke", 129), rep("nosmoke", 7))
sm4 <- c(rep("smoke", 70), rep("nosmoke", 12))
sm <- c(sm1, sm2, sm3, sm4)
grp <- c(rep("A",86), rep("B",93), rep("C",136), rep("D",82))
d <- data.frame(sm, grp)

## ---------------------------------------------------------------------------------------------------------------------
head(d)
tail(d)

## ---------------------------------------------------------------------------------------------------------------------
Prop_test(variable=sm, success="smoke", by=grp)

## ---------------------------------------------------------------------------------------------------------------------
x = c(5,6,4,6,15)
Prop_test(n_tot=x)

## ---------------------------------------------------------------------------------------------------------------------
x = c(5,6,4,6,15)
names(x) = c("ACCT", "ADMN", "FINC","MKTG","SALE")
Prop_test(n_tot=x)

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("Employee", quiet=TRUE)
Prop_test(Dept)

## ---------------------------------------------------------------------------------------------------------------------
Prop_test(Dept, by=Gender)

