% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-pointline.r
\name{geom_pointpath}
\alias{geom_pointpath}
\alias{geom_pointline}
\title{Connected points}
\usage{
geom_pointpath(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, distance = unit(3, "pt"), lineend = "butt",
  linejoin = "round", linemitre = 1, linesize = 0.5,
  linecolour = waiver(), linecolor = waiver(), arrow = NULL, ...)

geom_pointline(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, distance = unit(3, "pt"), lineend = "butt",
  linejoin = "round", linemitre = 1, linesize = 0.5,
  linecolour = waiver(), linecolor = waiver(), arrow = NULL, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}}
or \code{\link[ggplot2]{aes_}}.}

\item{data}{The data to be displayed in this layer.}

\item{stat}{The statistical transformation to use on the data for this layer, 
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a 
call to a position adjustment function
(e.g. \code{\link[ggplot2]{position_jitter}}).
Both lines and points gets the same adjustment 
(\emph{this} is where the function excels over \code{geom_point() + geom_line()}).}

\item{na.rm}{If \code{FALSE} (default), missing values are removed with a warning.
If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{Logical. Should this layer be included in the legends?
\code{NA} (default), includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetic, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the 
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{distance}{Gap size between point and end of lines;
use \code{\link[grid]{unit}}. Is converted to 'pt' if given as simple numeric.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mintre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{linesize}{Width of of line.}

\item{linecolour, linecolor}{When not \code{waiver()}, the line is drawn with 
this colour instead of that set by aesthetic \code{colour}.}

\item{arrow}{Arrow specification, as created by \code{\link[grid]{arrow}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}.}
}
\description{
\code{geom_pointpath} combines \code{\link[ggplot2]{geom_point}} and 
\code{\link[ggplot2]{geom_path}}, such that a) when jittering is used,
both lines and points stay connected, and b) provides a visual effect
by adding a small gap between the point and the end of line.
\code{geom_pointline} combines \code{\link[ggplot2]{geom_point}} and
\code{\link[ggplot2]{geom_line}}.
}
\details{
\code{geom_pointpath} connects the observations in the same order in which
they appear in the data.
\code{geom_pointline} connects them in order of the variable on the x-axis.

Both \code{geom_pointpath} and \code{geom_pointline} will only 
connect observations within the same group! However,
if \code{linecolour} is \emph{not} \code{waiver()}, connections
will be made between groups, but possible in an incorrect order.
}
\section{Aesthetics}{

\code{geom_pointline} and \code{geom_pointpath} understands the following 
aesthetics (required aesthetics are in bold):
\itemize{
  \item \strong{x}
  \item \strong{y}
  \item alpha
  \item colour -- sets colour of point. Only affects line if \code{linecolour=waiver()}. 
  \item stroke
  \item shape
  \item stroke
  \item group
  \item linetype
  \item size -- only affects point size. Width of line is set with 
        \code{linesize} and cannot be linked to an aesthetic.
}
}

\examples{
# geom_point examples
library(ggplot2)

p <- ggplot(mtcars, aes(wt, mpg))
p + geom_point() + geom_line()
p + geom_pointline()
p + geom_pointline(linecolour='brown')

# Add aesthetic mappings
p + geom_pointline(aes(colour = factor(cyl)))
# Using linecolour preserved groups.
p + geom_pointline(aes(colour = factor(cyl)), linecolour='brown') 

## If you want to combine the pretty lines of pointline that do *not* respect
## grouping (or order), combine several layers with geom_point on top:
p + geom_pointline() + geom_point(aes(colour=factor(cyl)))

p + geom_point(aes(shape = factor(cyl)))
p + geom_pointline(aes(shape = factor(cyl)))
p + geom_point(aes(size = qsec))
p + geom_pointline(aes(size=qsec))

# Change scales
p + geom_pointline(aes(colour = cyl)) + scale_colour_gradient(low = "blue")
p + geom_pointline(aes(colour = cyl), linecolour='black') + scale_colour_gradient(low = "blue")
p + geom_pointline(aes(shape = factor(cyl))) + scale_shape(solid = FALSE)


# For shapes that have a border (like 21), you can colour the inside and
# outside separately. Use the stroke aesthetic to modify the width of the
# border
ggplot(mtcars, aes(wt, mpg)) +
  geom_pointline(shape = 21, colour = "black", fill = "white", 
                 size = 5, stroke = 5, distance = unit(10, 'pt'))

# geom_line() examples, updated to geom_pointline

# geom_line() is suitable for time series
ggplot(economics, aes(date, unemploy)) + geom_pointline()
ggplot(economics_long, aes(date, value01, colour = variable)) +
  geom_pointline()


# geom_step() is useful when you want to highlight exactly when
# the y value chanes
recent <- economics[economics$date > as.Date("2013-01-01"), ]
ggplot(recent, aes(date, unemploy)) + geom_pointline()
ggplot(recent, aes(date, unemploy)) + geom_step() 
# geom_pointstep is not implemented; no idea of what to expect.

# geom_path lets you explore how two variables are related over time,
# e.g. unemployment and personal savings rate
m <- ggplot(economics, aes(unemploy/pop, psavert))
m + geom_pointpath()
m + geom_pointpath(aes(colour = as.numeric(date)))

# NAs break the line. Use na.rm = T to suppress the warning message
df <- data.frame(
  x = 1:5,
  y1 = c(1, 2, 3, 4, NA),
  y2 = c(NA, 2, 3, 4, 5),
  y3 = c(1, 2, NA, 4, 5)
)
ggplot(df, aes(x, y1)) + geom_point() + geom_line()
ggplot(df, aes(x, y1)) + geom_pointline()

ggplot(df, aes(x, y3)) + geom_point() + geom_line()
#geom_pointline does not break where NA's are missing.
ggplot(df, aes(x, y3)) + geom_pointline() 


# Setting line type vs colour/size
# Line type needs to be applied to a line as a whole, so it can
# not be used with colour or size that vary across a line
x <- seq(0.01, .99, length.out = 100)
df <- data.frame(
  x = rep(x, 2),
  y = c(qlogis(x), 2 * qlogis(x)),
  group = rep(c("a","b"),
              each = 100)
)
p <- ggplot(df, aes(x=x, y=y, group=group))
# These work
p + geom_pointline(linetype=2)
p + geom_pointline(aes(colour = group), linetype = 2)
p + geom_line(aes(colour = x))
p + geom_pointline(aes(colour = x))
}
