% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_member.R
\name{search_member}
\alias{search_member}
\alias{legco_search_member}
\title{Search LegCo Member}
\usage{
search_member(
  search_string = NULL,
  speaker_id = NULL,
  member_id = NULL,
  exact = TRUE,
  verbose = TRUE
)

legco_search_member(
  search_string = NULL,
  speaker_id = NULL,
  member_id = NULL,
  exact = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{search_string}{search string of member's name. Accepts Chinese or
English full or partial name. Defaults to \code{NULL}.}

\item{speaker_id}{the id of a speaker at the Legislative Council, or a vector
of ids. If \code{NULL}, returns all speakers. Defaults to \code{NULL}.}

\item{member_id}{the id of a LegCo member, or a vector of ids. If
\code{NULL}, returns results of all LegCo members. Defaults to \code{NULL}.}

\item{exact}{logical: Whether to look for exact match of the search term.
Defaults to \code{TRUE}.}

\item{verbose}{logical: Whether to display progress messages when fetching
data? Defaults to \code{TRUE}.}
}
\description{
Search LegCo member by SpeakerID, MemberID or/and full or partial English or
Chinese name.
}
\details{
This is a complementary function to \code{\link{speakers}()} and
\code{\link{member}()}.
}
\section{Functions}{
 Complementary Functions: \itemize{ \item
  \code{\link{search_committee}}: Search LegCo committees \item
  \code{\link{search_member}}: Search LegCo members \item
  \code{\link{search_voting_record}}: Search Voting Record in LegCo meetings
  \item \code{\link{search_question}}: Search full text of question put to
  the government by LegCo members}
}

\section{Notes}{
 The complementary functions work by calling a number of
  database functions and combining their output, meaning that a function call
  usually involves multiple API calls. Use with caution to prevent reaching
  the API’s rate limit too quickly.
}

