% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attendance.R
\name{attendance}
\alias{attendance}
\alias{legco_attendance}
\title{Attendance of LegCo Members}
\usage{
attendance(
  committee_id = NULL,
  meet_id = NULL,
  member_id = NULL,
  attn = "all",
  from = "1900-01-01",
  to = Sys.Date(),
  n = 1000,
  extra_param = NULL,
  count = FALSE,
  verbose = TRUE
)

legco_attendance(
  committee_id = NULL,
  meet_id = NULL,
  member_id = NULL,
  attn = "all",
  from = "1900-01-01",
  to = Sys.Date(),
  n = 1000,
  extra_param = NULL,
  count = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{committee_id}{the id of a committee, or a vector of ids. If
\code{NULL}, returns results of all committees. Defaults to \code{NULL}.}

\item{meet_id}{the id of a meeting, or a vector of ids. If \code{NULL},
returns all meetings. Useful for matching meeting with records from the
Attendance Database. Defaults to \code{NULL}.}

\item{member_id}{the id of a LegCo member, or a vector of ids. If
\code{NULL}, returns results of all LegCo members. Defaults to \code{NULL}.}

\item{attn}{the attendance. \code{"p"} returns members who were present.
\code{"a"} returns members who were absent. \code{"all"} returns all
members. Defaults to \code{"all"}.}

\item{from}{only fetch results of meetings on or after this date. Accepts
character values in \code{"YYYY-MM-DD"} format, and objects of class
\code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or anything else
that can be coerced to a date with \code{as.Date()}. Defaults to
\code{"1900-01-01"}.}

\item{to}{only fetch results of meetings on or before this date. Accepts
character values in \code{"YYYY-MM-DD"} format, and objects of class
\code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or anything else
that can be coerced to a date with \code{as.Date()}. Defaults to the
current system date.}

\item{n}{the number of record to fetch. Defaults to \code{1000}.}

\item{extra_param}{additional query parameters defined in LegCo API. Must
begin with \code{"&"}.}

\item{count}{logical: Whether to return only the total count of records that
matches the parameter(s) instead of the result. Defaults to \code{FALSE}.}

\item{verbose}{logical: Whether to display progress messages when fetching
data? Defaults to \code{TRUE}.}
}
\description{
Fetch attendance record of LegCo committee meetings
}
\details{
This function corresponds to the \emph{Tattendance} data endpoint of the
Meeting Attendance Database.
}
\examples{
\donttest{
# Fetch members who were absent from the Subcommittee on Issues
# Relating to Bazaars meetings on October 13, 2017
x <- attendance(committee_id = 2704, from = "2017-10-13", to = "2017-10-13", attn = "a")
}

}
\seealso{
LegCo API documentation for the Attendance database:
  \url{https://www.legco.gov.hk/odata/english/attendance-db.html}
}
