% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convex.R
\name{lawn_convex}
\alias{lawn_convex}
\title{Convex hull polygon}
\usage{
lawn_convex(input, lint = FALSE)
}
\arguments{
\item{input}{Input points in a \link{data-FeatureCollection}.}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
a convex hull \link{data-Polygon}
}
\description{
Takes a set of \link{data-Point}'s and returns a convex
hull polygon. Internally, this uses the
convex-hull  module
that implements a Monotone chain hull
}
\examples{
points <- '{
  "type": "FeatureCollection",
  "features": [
    {
      "type": "Feature",
      "properties": {},
      "geometry": {
        "type": "Point",
        "coordinates": [-63.601226, 44.642643]
      }
    }, {
      "type": "Feature",
      "properties": {},
      "geometry": {
        "type": "Point",
        "coordinates": [-63.591442, 44.651436]
      }
    }, {
      "type": "Feature",
      "properties": {},
      "geometry": {
        "type": "Point",
        "coordinates": [-63.580799, 44.648749]
      }
    }, {
      "type": "Feature",
      "properties": {},
      "geometry": {
        "type": "Point",
        "coordinates": [-63.573589, 44.641788]
      }
    }, {
      "type": "Feature",
      "properties": {},
      "geometry": {
        "type": "Point",
        "coordinates": [-63.587665, 44.64533]
      }
    }, {
      "type": "Feature",
      "properties": {},
      "geometry": {
        "type": "Point",
        "coordinates": [-63.595218, 44.64765]
      }
    }
    ]
}'
lawn_convex(points)
\dontrun{
lawn_convex(points) \%>\% view
}
}
\seealso{
Other transformations: 
\code{\link{lawn_bezier}()},
\code{\link{lawn_buffer}()},
\code{\link{lawn_concave}()},
\code{\link{lawn_difference}()},
\code{\link{lawn_intersect}()},
\code{\link{lawn_merge}()},
\code{\link{lawn_simplify}()},
\code{\link{lawn_union}()}
}
\concept{transformations}
