% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_pt2line_distance.R
\name{lawn_pt2line_distance}
\alias{lawn_pt2line_distance}
\title{Minimum distance between a point and a lineString}
\usage{
lawn_pt2line_distance(point, line, units = "kilometers",
  mercator = FALSE, lint = FALSE)
}
\arguments{
\item{point}{(\link{data-Feature}<(\link{data-Point})>) feature or geometry}

\item{line}{Line to measure, a \link{data-Feature}<(\link{data-LineString})>,
or \link{data-FeatureCollection}<(\link{data-LineString})>}

\item{units}{(character) Can be degrees, radians, miles, or kilometers
(default)}

\item{mercator}{(logical) if distance should be on Mercator or WGS84
projection. Default: \code{FALSE}}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
distance between point and line (numeric)
}
\description{
Returns the minimum distance between a \link{data-Point} and a \link{data-LineString},
being the distance from a line the minimum distance between the
point and any segment of the LineString.
}
\examples{
pt <- lawn_point("[0, 0]")
ln <- lawn_linestring("[[1, 1],[-1, 1]]")

lawn_pt2line_distance(pt, ln)
lawn_pt2line_distance(pt, ln, mercator = TRUE)

lawn_pt2line_distance(pt, ln, 'miles')
lawn_pt2line_distance(pt, ln, 'radians')
lawn_pt2line_distance(pt, ln, 'degrees')
lawn_pt2line_distance(pt, ln, mercator = TRUE)
}
\seealso{
Other measurements: \code{\link{lawn_along}},
  \code{\link{lawn_area}}, \code{\link{lawn_bbox_polygon}},
  \code{\link{lawn_bbox}}, \code{\link{lawn_bearing}},
  \code{\link{lawn_center_of_mass}},
  \code{\link{lawn_center}}, \code{\link{lawn_centroid}},
  \code{\link{lawn_destination}},
  \code{\link{lawn_distance}}, \code{\link{lawn_envelope}},
  \code{\link{lawn_extent}},
  \code{\link{lawn_line_distance}},
  \code{\link{lawn_midpoint}},
  \code{\link{lawn_point_on_surface}},
  \code{\link{lawn_square}}
}
\concept{measurements}
