% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove.R
\name{lawn_remove}
\alias{lawn_remove}
\title{Remove things from a FeatureCollection}
\usage{
lawn_remove(features, property, value, lint = FALSE)
}
\arguments{
\item{features}{A set of input features.}

\item{property}{Property to filter.}

\item{value}{Value to filter.}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
A \link{data-FeatureCollection}.
}
\description{
Takes a \link{data-FeatureCollection} of any type, a property, and a
value and returns a \link{data-FeatureCollection} with features
matching that property-value pair removed.
}
\examples{
cat(lawn_data$remove_features)
lawn_remove(lawn_data$remove_features, 'marker-color', '#00f')
lawn_remove(lawn_data$remove_features, 'marker-color', '#0f0')
}
\seealso{
Other data functions: \code{\link{lawn_featurecollection}},
  \code{\link{lawn_feature}}, \code{\link{lawn_filter}},
  \code{\link{lawn_geometrycollection}},
  \code{\link{lawn_linestring}},
  \code{\link{lawn_multilinestring}},
  \code{\link{lawn_multipoint}},
  \code{\link{lawn_multipolygon}},
  \code{\link{lawn_point}}, \code{\link{lawn_polygon}},
  \code{\link{lawn_random}}, \code{\link{lawn_sample}}
}
