% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countreg.R
\name{countreg}
\alias{countreg}
\title{Fitting Count Regression Models with Latent Covariates}
\usage{
countreg(
  forml,
  data,
  lv = NULL,
  group = NULL,
  family = "poisson",
  silent = FALSE,
  se = TRUE,
  creg_options = NULL
)
}
\arguments{
\item{forml}{An object of class \code{\link[stats]{formula}} (or one
that can be coerced to that class): a symbolic description of the model to
be fitted. The details of model specification are given under Details.}

\item{data}{A data frame containing all variables specified in \code{forml}
and/or indicators of the latent variables specified in \code{lv} (if
applicable).}

\item{lv}{A named list, where names of elements represent the names of the
 latent variables and each element consists of a character vector containing
variable names of indicators for the respective latent variable, e.g.,
\code{list(eta1 = c("z1", "z2", "z3"))}.}

\item{group}{A group variable. If specified, the regression model specified
in \code{forml} is estimated as multi-group model (i.e., within each group).}

\item{family}{A character indicating the family of the generalized linear
model to be estimated. At the moment, \code{"poisson"} (for Poisson
regression; default) or \code{"nbinom"} (for negative binomial regression)
are available.}

\item{silent}{Logical. Should informations about the estimation process
be suppressed? (Defaults to FALSE)}

\item{se}{Logical. Should standard errors be computed? Defaults to TRUE.
(Can take a while for complex models)}

\item{creg_options}{optional list of additional options for the estimation
procedure}
}
\value{
An object of type \code{lavacreg}. Use \code{summary(object)} to
print results containing parameter estimates and their standard errors.
}
\description{
This function is the main function of the package and can be used to estimate
latent variable count regression models in one or multiple group(s).
}
\examples{
fit <- countreg(forml = "dv ~ z11", data = example01, family = "poisson")
summary(fit)
\donttest{
fit <- countreg(
  forml = "dv ~ eta1 + z11 + z21",
  lv = list(eta1 = c("z41", "z42", "z43")),
  group = "treat",
  data = example01,
  family = "poisson"
)
summary(fit)
}

}
