% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initVarlink.R
\name{initVarLink}
\alias{initVarLink}
\alias{initVarLinks}
\title{Normalize var1 and var2}
\usage{
initVarLink(var1, var2, repVar1 = FALSE, format = "list",
  Slink = c(lava.options()$symbols[1], "~"),
  Scov = lava.options()$symbols[2])

initVarLinks(var1, format = "list", ...)
}
\arguments{
\item{var1}{a character indicating the endogeneous variable or a formula}

\item{var2}{an optional character indicating the exogeneous variable}

\item{repVar1}{should var1 be duplicated to match var2 length. Only active if format = "list".}

\item{format}{should the name of the variable be return (format = "list"), a vector of character formula ("txt.formula") or a list of formula ("formula")}

\item{Slink}{the symbol for regression link}

\item{Scov}{the symbol for covariance link}

\item{...}{argument to be passed to lower level functions}
}
\description{
Convert var1 and var2 from formula or covariance to character.
}
\details{
See test file test/testthat/test-Reduce.R for examples
}
\examples{
initVarLink(y ~ x1)
initVarLink("y ~ x1")
initVarLink(y ~ x1 + x2)
initVarLink("y ~ x1 + x2")
initVarLink(y ~ x1 + x2, repVar1 = TRUE)
initVarLink(y ~ x1 + x2, repVar1 = TRUE, format = "formula")
initVarLink(y ~ x1 + x2, repVar1 = TRUE, format = "txt.formula")
initVarLink("y", "x1", format = "formula")

initVarLink("y ~ x1:0|1")

initVarLinks(y ~ x1)
initVarLinks("y ~ x1")
initVarLinks(c("y ~ x1","y~ x2"))
initVarLinks(c(y ~ x1,y ~ x2))
initVarLinks(c("y ~ x1","y ~ x2"), format = "formula")
initVarLinks(c(y ~ x1,y ~ x2), format = "formula")
initVarLinks(c("y ~ x1","y~ x2"), format = "txt.formula")
initVarLinks(c(y ~ x1,y ~ x2), format = "txt.formula")
}
