% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlf2.R
\name{glht}
\alias{glht}
\alias{glht.mlf2}
\alias{glht2}
\title{General Linear Hypothesis}
\usage{
\method{glht}{mlf2}(model, linfct, ...)

glht2(model, linfct, adjust.residuals = TRUE, robust = FALSE, ...)
}
\arguments{
\item{model}{a list of latent variable models.}

\item{linfct}{a contrast matrix specifying the linear hypotheses to be tested.}

\item{...}{arguments passed to \code{glht}, \code{vcov}, and \code{lTest}.}

\item{adjust.residuals}{Small sample correction: should the leverage-adjusted residuals be used to compute the score? Otherwise the raw residuals will be used.}

\item{robust}{should robust standard error be used? 
Otherwise rescale the influence function with the standard error obtained from the information matrix.}
}
\description{
Test general linear hypotheses and across latent variable models.
}
\examples{
library(multcomp)

## Simulate data
mSim <- lvm(c(Y1,Y2,Y3)~ beta * eta, E ~ 1)
latent(mSim) <- "eta"
set.seed(10)
n <- 1e2

df.data <- sim(mSim, n, latent = FALSE, p = c(beta = 1))

## Fit separate models
ls.lvm <- list(Y1 = estimate(lvm(Y1~E), data = df.data),
               Y2 = estimate(lvm(Y2~E), data = df.data),
               Y3 = estimate(lvm(Y3~E), data = df.data))

## Create contrast matrix
C <- createContrast(ls.lvm, var.test = "E")

lvm.glht <- glht2(ls.lvm, linfct = C)
summary(lvm.glht) ## adjusted

summary(lvm.glht, test = univariate()) ## not adjusted
}
