% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/method.R, R/model.R,
%   R/variables.R
\name{timeVariable}
\alias{timeVariable}
\alias{timeVariable,lcMethod-method}
\alias{timeVariable,lcModel-method}
\alias{timeVariable,ANY-method}
\alias{timeariable,ANY-method}
\title{Extract the time variable}
\usage{
timeVariable(object, ...)

\S4method{timeVariable}{lcMethod}(object, ...)

\S4method{timeVariable}{lcModel}(object)

\S4method{timeVariable}{ANY}(object)
}
\arguments{
\item{object}{The object.}

\item{...}{Not used.}
}
\value{
The time variable name, as \code{character}.
}
\description{
Extracts the time variable (i.e., column name) from the given \code{object}.
}
\examples{
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
timeVariable(method) # "Time"
data(latrendData)
method <- lcMethodRandom("Y", id = "Id", time = "Time")
model <- latrend(method, latrendData)
timeVariable(model) # "Time"
}
\seealso{
Other variables: 
\code{\link{idVariable}()},
\code{\link{responseVariable}()}
}
\concept{variables}
