% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodGCKM.R
\name{lcMethodGCKM}
\alias{lcMethodGCKM}
\title{Two-step clustering through linear mixed modeling and k-means}
\usage{
lcMethodGCKM(
  formula,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  nClusters = 2,
  center = meanNA,
  ...
)
}
\arguments{
\item{formula}{Formula, including a random effects component for the trajectory. See \link[lme4:lmer]{lme4::lmer} formula syntax.}

\item{time}{The name of the time variable..}

\item{id}{The name of the trajectory identifier variable.}

\item{nClusters}{The number of clusters.}

\item{center}{Optional \code{function} for computing the longitudinal cluster centers, with signature \code{(x)}.}

\item{...}{Arguments passed to \link[lme4:lmer]{lme4::lmer}.
The following external arguments are ignored: data, centers, trace.}
}
\description{
Two-step clustering through linear mixed modeling and k-means.
}
\examples{
library(lme4)
data(latrendData)
method <- lcMethodGCKM(Y ~ (Time | Id), id = "Id", time = "Time", nClusters = 3)
model <- latrend(method, latrendData)
}
\seealso{
Other lcMethod implementations: 
\code{\link{lcMethod-class}},
\code{\link{lcMethodAkmedoids}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodCustom}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFeature}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodLongclust}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodRandom}},
\code{\link{lcMethodStratify}}
}
\concept{lcMethod implementations}
