% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodMixAK_GLMM.R
\name{lcMethodMixAK_GLMM}
\alias{lcMethodMixAK_GLMM}
\title{Specify a GLMM iwht a normal mixture in the random effects}
\usage{
lcMethodMixAK_GLMM(
  fixed,
  random,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  nClusters = 2,
  ...
)
}
\arguments{
\item{fixed}{A \code{formula} specifying the fixed effects of the model, including the response. Creates the \code{y} and \code{x} arguments for the call to \link[mixAK:GLMMMCMC]{mixAK::GLMM_MCMC}.}

\item{random}{A \code{formula} specifying the random effects of the model, including the random intercept. Creates the \code{z} and \code{random.intercept} arguments for the call to \link[mixAK:GLMMMCMC]{mixAK::GLMM_MCMC}.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identifier variable. This is used to generate the \code{id} vector argument for the call to \link[mixAK:GLMMMCMC]{mixAK::GLMM_MCMC}.}

\item{nClusters}{The number of clusters.}

\item{...}{Arguments passed to \link[mixAK:GLMMMCMC]{mixAK::GLMM_MCMC}.
The following external arguments are ignored: y, x, z, random.intercept, silent.}
}
\description{
Specify a GLMM iwht a normal mixture in the random effects
}
\examples{
data(latrendData)
method <- lcMethodMixAK_GLMM(fixed = Y ~ 1, random = ~ Time,
  id = "Id", time = "Time", nClusters = 3)
model <- latrend(method, latrendData)
summary(model)
}
\seealso{
Other lcMethod implementations: 
\code{\link{lcMethod-class}},
\code{\link{lcMethodAKMedoids}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodCustom}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodLongclust}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodRandom}},
\code{\link{lcMethodStratify}},
\code{\link{lcMethodTwoStep}}
}
\concept{lcMethod implementations}
