% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stocks.R
\name{splot_etf}
\alias{splot_etf}
\title{Portfolio's Sector Distribution (ETFs)}
\usage{
splot_etf(s, keep_all = FALSE, cache = TRUE, save = FALSE)
}
\arguments{
\item{s}{Dataframe. Result from \code{daily_stocks()}}

\item{keep_all}{Boolean. Keep "Not Known / Not ETF"?}

\item{cache}{Boolean. Use daily cache if available?}

\item{save}{Boolean. Save plot into a local file?}
}
\value{
ggplot2 object
}
\description{
This function lets the user plot his portfolio's distribution,
specifically ETF's sectors
}
\seealso{
Other Investment: 
\code{\link{daily_portfolio}()},
\code{\link{daily_stocks}()},
\code{\link{etf_sector}()},
\code{\link{splot_change}()},
\code{\link{splot_divs}()},
\code{\link{splot_growth}()},
\code{\link{splot_roi}()},
\code{\link{splot_summary}()},
\code{\link{splot_types}()},
\code{\link{stocks_file}()},
\code{\link{stocks_obj}()},
\code{\link{stocks_quote}()},
\code{\link{stocks_report}()}

Other Investment Plots: 
\code{\link{splot_change}()},
\code{\link{splot_divs}()},
\code{\link{splot_growth}()},
\code{\link{splot_roi}()},
\code{\link{splot_summary}()},
\code{\link{splot_types}()}

Other Scrapper: 
\code{\link{filesGD}()},
\code{\link{get_mp3}()},
\code{\link{gtrends_related}()},
\code{\link{holidays}()},
\code{\link{ip_data}()},
\code{\link{readGS}()},
\code{\link{stocks_quote}()}
}
\concept{Investment}
\concept{Investment Plots}
\concept{Scrapper}
