% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling.R
\name{date_cuts}
\alias{date_cuts}
\title{Convert Date into Year + Cut}
\usage{
date_cuts(date = Sys.Date(), type = "Q")
}
\arguments{
\item{date}{Date. Date we wish to transform}

\item{type}{Character. Any of the following: B (2 months),
Q (3 months), T (4 months), H (6 months)}
}
\value{
Vector with date cut for each \code{date}
}
\description{
This function returns categorical values for any date(s) using year
cuts such as bimonths, quarters, terms, and halves.
}
\examples{
date_cuts(Sys.Date(), type = "Q")
date_cuts(Sys.Date(), type = "H")
}
\seealso{
Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_feats}()},
\code{\link{file_name}()},
\code{\link{formatHTML}()},
\code{\link{holidays}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{num_abbr}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{quants}()},
\code{\link{removenacols}()},
\code{\link{replaceall}()},
\code{\link{replacefactor}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()},
\code{\link{zerovar}()}
}
\concept{Data Wrangling}
