% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colour_palettes.R
\name{lares_pal}
\alias{lares_pal}
\title{Personal Colours Palette}
\usage{
lares_pal(return = "list")
}
\arguments{
\item{return}{Character. Get only what you need. Select any of:
"all" or "list" (list),
"colors" or "colours" (vector),
"pal" or "palette" (named vector),
"simple" (named vector),
"custom" or "personal" (data.frame)}
}
\value{
Depending on the \code{return} input, we get a:
\itemize{
  \item \code{vector} with \code{palette} results vector
  \item \code{vector} with \code{palette} results vector's names
  \item \code{list} with \code{palette} results vector, \code{labels}
  results data.frame, and \code{simple} results named vector
}
}
\description{
This function plots a list of colours on a specific palette
}
\examples{
# Simple colour-named palette
lares_pal("simple")

# Raw colours and counter-colours
# OR simply: lares_pal("palette")
nice_palette <- lares_pal("colours")
nice_palette_ctr <- as.vector(lares_pal()$palette)
lapply(list(nice_palette, nice_palette_ctr), head)

# Personal colours by name
df <- lares_pal("custom")
df[sample(nrow(df), 5), ]
}
\seealso{
Other Auxiliary: 
\code{\link{gg_colour_customs}()},
\code{\link{gg_fill_customs}()},
\code{\link{gg_text_customs}()},
\code{\link{plot_palette}()}
}
\concept{Auxiliary}
