% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_mining.R
\name{cleanNames}
\alias{cleanNames}
\title{Clean title names of a data.frame/tibble object}
\usage{
cleanNames(df, num = "x", ...)
}
\arguments{
\item{df}{data.frame/tibble}

\item{num}{Add character before only-numeric names}

\item{...}{Additional parameters passed to \code{cleanText}}
}
\value{
Character vector with transformed strings.
}
\description{
Resulting names are unique and consist only of the \code{_} character, 
numbers, and ASCII letters. Capitalization preferences can be specified using 
the \code{lower} parameter. Inspired by \code{janitor::clean_names}.
}
\examples{
df <- dft[1:5,1:6] # Dummy data
colnames(df) <- c("ID.", "34", "x_2", "Num 123", "Nòn-äscì", "  white   Spaces  ")
print(df)
cleanNames(df)
cleanNames(df, lower = FALSE)
}
\seealso{
Other Text Mining: 
\code{\link{cleanText}()},
\code{\link{ngrams}()},
\code{\link{remove_stopwords}()},
\code{\link{replaceall}()},
\code{\link{sentimentBreakdown}()},
\code{\link{textCloud}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{topics_rake}()}
}
\concept{Text Mining}
