% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{loadPathogen}
\alias{loadPathogen}
\title{Load pathogen parameters}
\usage{
loadPathogen(disease = "rust")
}
\arguments{
\item{disease}{a disease name, among "rust" (default), "mildew", "sigatoka" and "no pathogen"}
}
\value{
a list of pathogen parameters on a susceptible host
for a pathogen genotype not adapted to resistance
}
\description{
Loads default pathogen parameters for a specific disease
}
\details{
Available diseases:
\itemize{
\item "no pathogen"
\item "rust" (genus \emph{Puccinia}, e.g. stripe rust, stem rust and leaf rust of wheat and barley)
\item "mildew" (\emph{Plasmopara viticola}, downy mildew of grapevine)
\item "sigatoka" (\emph{Pseudocercospora fijiensis}, black sigatoka of banana)
Note that when disease = "mildew" a price reduction between 0\% and 5\% is applied to the market value
according to disease severity.
}
}
\examples{
basic_patho_params <- loadPathogen()
basic_patho_params
}
\seealso{
\link{setPathogen}
}
