% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_raster2tibble.R
\name{util_raster2tibble}
\alias{util_raster2tibble}
\title{Converts raster data into tibble}
\usage{
util_raster2tibble(x)

util_raster2tibble(x)
}
\arguments{
\item{x}{Raster* object}
}
\value{
a tibble
}
\description{
Writes spatial raster values into tibble and adds coordinates.
}
\details{
You will loose any resolution, extent or reference system.
The output is raw tiles.
}
\examples{
maptib <- util_raster2tibble(fractal_landscape)
\dontrun{
library(ggplot2)
ggplot(maptib, aes(x,y)) +
    coord_fixed() +
    geom_raster(aes(fill = z))
}
}
