% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_to_raster.R
\name{matrix_to_raster}
\alias{matrix_to_raster}
\title{matrix_to_raster}
\usage{
matrix_to_raster(
  matrix,
  landscape = NULL,
  landscape_empty = FALSE,
  extent = NULL,
  resolution = NULL,
  crs = NULL,
  to_disk = getOption("to_disk", default = FALSE)
)
}
\arguments{
\item{matrix}{matrix with values.}

\item{landscape}{SpatRaster}

\item{landscape_empty}{If true, SpatRaster is landscape_empty}

\item{extent}{Extent of SpatRaster}

\item{resolution}{Resolution of SpatRaster}

\item{crs}{CRS of raster layer.}

\item{to_disk}{If TRUE raster will be saved to disk.}
}
\value{
raster
}
\description{
Convert matrix to raster
}
\details{
Converts \code{matrix} to a raster with same characteristics as \code{landscape}. Either
\code{landscape} or \code{extent}, \code{resolution} and \code{crs} must be specified.
}
\examples{
augusta_nlcd <- terra::rast(landscapemetrics::augusta_nlcd)

test_matrix <- terra::as.matrix(augusta_nlcd, wide = TRUE)
matrix_to_raster(matrix = test_matrix, landscape = augusta_nlcd)

}
\keyword{internal}
